# lein-lib

Leiningen plugin for building local libraries from source.

A Clojure service living inside the monorepo can require libraries also in the monorepo.

Unlike listing the dependency in `:dependencies`, lein-lib will include the library in `:source-paths` and `:resource-paths`, compiling the library files each time the service is compiled. It will handle `:dependencies` of the local library by concatenating them to the `:dependencies` of the requiring service.

Libraries can require each other using the `lein-lib` convention, and any top-level parent library will include all libraries discovered along this local dependency tree.

Requires the Truly monorepo, source-controlled at the top level with all subprojects in their own directories at the top level.

e.g.,
```
<root>/
   clj-core-common/
   core-api/
   ...
```
Deployed to clojars at https://clojars.org/com.trulywireless/lein-lib

## Usage

To use, navigate to require `lein-lib` in the plugins key of project.clj files.
E.g.,

```
:plugins [[com.trulywireless/lein-lib "0.3.0-SNAPSHOT"]]
```

Note that this pulls from clojars, NOT our private s3 respository

To add a local dependency, add a `:local-libs` key whose value is a list of strings of directory names. Each directory name should be the root of a local library.

e.g.,

```
;; Building with external artifacts (not using lein-lib)
:dependencies [...<maven-style coordinates here>...]
;; Building from source (using lein lib)
:local-libs ["clj-core-common" "clj-utils"]
...
:plugins [[com.trulywireless/lein-lib "0.3.0-SNAPSHOT"] ...]
```

Note that lein-lib will operate recursively for each project that uses it, so libraries can use lein-lib to require other libraries.

## Development

Currently, the main code for this plugin lives in `plugins.clj`. Operate on middleware in that namespace and run `lein install` to test locally.

You can deploy this to clojars with `lein deploy`. However, *DO NOT DEPLOY WITH ANY CODE THAT IS MEANT TO BE PRIVATE*. The clojars library is public. Credentials must be set in a local profile under `[:auth :repository-auth]`. The clojars user `truly`. That is, add a key like this:

```
:auth {:repository-auth {#"https://clojars.org/repo" {:username "truly" :password <MY_CLOJARS_PASSWORD>}}}
```

At mentioned, this project is deployed to clojars. This is because of some problem in deploying and requiring from our private S3 repository. As of this writing, we believe that requiring the plugin in `:plugins` of some consuming project attempts to load the library before the leiningen S3 wagon (`lein-aws-maven`). As a result, projects that require `lein-lib` cannot seem to download it.

Note that `lein install`, which bypasses any remote repository download, works.

## License

Copyright © 2017 Truly Wireless
