/*
 * Decompiled with CFR 0.152.
 */
package com.twilight.h264.decoder;

import com.twilight.h264.decoder.AVComponentDescriptor;
import com.twilight.h264.decoder.AVFrame;
import com.twilight.h264.decoder.AVPacket;
import com.twilight.h264.decoder.AVPanScan;
import com.twilight.h264.decoder.AVPicture;
import com.twilight.h264.decoder.AVPixFmtDescriptor;
import com.twilight.h264.decoder.AVRational;
import com.twilight.h264.decoder.DSPContext;
import com.twilight.h264.decoder.ErrorResilience;
import com.twilight.h264.decoder.GetBitContext;
import com.twilight.h264.decoder.H264Context;
import com.twilight.h264.decoder.H264Decoder;
import com.twilight.h264.decoder.ImageUtils;
import com.twilight.h264.decoder.InternalBuffer;
import com.twilight.h264.decoder.MotionEstContext;
import com.twilight.h264.decoder.ParseContext;
import com.twilight.h264.decoder.SEIDecoder;
import com.twilight.h264.decoder.ScanTable;
import com.twilight.h264.util.Arrays;

public class MpegEncContext {
    public static final int AVMEDIA_TYPE_VIDEO = 0;
    public static final int AV_OPT_FLAG_DECODING_PARAM = 2;
    public static final int AV_OPT_FLAG_VIDEO_PARAM = 16;
    public static final int[] ff_default_chroma_qscale_table;
    public static final int[] ff_mpeg1_dc_scale_table;
    public int has_b_frames;
    public static final int FF_QSCALE_TYPE_H264 = 2;
    public static final int VP_START = 1;
    public static final int AC_ERROR = 2;
    public static final int DC_ERROR = 4;
    public static final int MV_ERROR = 8;
    public static final int AC_END = 16;
    public static final int DC_END = 32;
    public static final int MV_END = 64;
    public static final int FF_BUFFER_TYPE_INTERNAL = 1;
    public static final int FF_BUFFER_TYPE_USER = 2;
    public static final int FF_BUFFER_TYPE_SHARED = 4;
    public static final int FF_BUFFER_TYPE_COPY = 8;
    public static final int PICT_TOP_FIELD = 1;
    public static final int PICT_BOTTOM_FIELD = 2;
    public static final int PICT_FRAME = 3;
    public static final int CODEC_FLAG_QSCALE = 2;
    public static final int CODEC_FLAG_4MV = 4;
    public static final int CODEC_FLAG_QPEL = 16;
    public static final int CODEC_FLAG_GMC = 32;
    public static final int CODEC_FLAG_MV0 = 64;
    public static final int CODEC_FLAG_PART = 128;
    public static final int CODEC_FLAG_INPUT_PRESERVED = 256;
    public static final int CODEC_FLAG_PASS1 = 512;
    public static final int CODEC_FLAG_PASS2 = 1024;
    public static final int CODEC_FLAG_EXTERN_HUFF = 4096;
    public static final int CODEC_FLAG_GRAY = 8192;
    public static final int CODEC_FLAG_EMU_EDGE = 16384;
    public static final int CODEC_FLAG_PSNR = 32768;
    public static final int CODEC_FLAG_TRUNCATED = 65536;
    public static final int CODEC_FLAG_NORMALIZE_AQP = 131072;
    public static final int CODEC_FLAG_INTERLACED_DCT = 262144;
    public static final int CODEC_FLAG_LOW_DELAY = 524288;
    public static final int CODEC_FLAG_ALT_SCAN = 0x100000;
    public static final int CODEC_FLAG_GLOBAL_HEADER = 0x400000;
    public static final int CODEC_FLAG_BITEXACT = 0x800000;
    public static final int CODEC_FLAG_AC_PRED = 0x1000000;
    public static final int CODEC_FLAG_H263P_UMV = 0x2000000;
    public static final int CODEC_FLAG_CBP_RD = 0x4000000;
    public static final int CODEC_FLAG_QP_RD = 0x8000000;
    public static final int CODEC_FLAG_H263P_AIV = 8;
    public static final int CODEC_FLAG_OBMC = 1;
    public static final int CODEC_FLAG_LOOP_FILTER = 2048;
    public static final int CODEC_FLAG_H263P_SLICE_STRUCT = 0x10000000;
    public static final int CODEC_FLAG_INTERLACED_ME = 0x20000000;
    public static final int CODEC_FLAG_SVCD_SCAN_OFFSET = 0x40000000;
    public static final int CODEC_FLAG_CLOSED_GOP = Integer.MIN_VALUE;
    public static final int CODEC_FLAG2_FAST = 1;
    public static final int CODEC_FLAG2_STRICT_GOP = 2;
    public static final int CODEC_FLAG2_NO_OUTPUT = 4;
    public static final int CODEC_FLAG2_LOCAL_HEADER = 8;
    public static final int CODEC_FLAG2_BPYRAMID = 16;
    public static final int CODEC_FLAG2_WPRED = 32;
    public static final int CODEC_FLAG2_MIXED_REFS = 64;
    public static final int CODEC_FLAG2_8X8DCT = 128;
    public static final int CODEC_FLAG2_FASTPSKIP = 256;
    public static final int CODEC_FLAG2_AUD = 512;
    public static final int CODEC_FLAG2_BRDO = 1024;
    public static final int CODEC_FLAG2_INTRA_VLC = 2048;
    public static final int CODEC_FLAG2_MEMC_ONLY = 4096;
    public static final int CODEC_FLAG2_DROP_FRAME_TIMECODE = 8192;
    public static final int CODEC_FLAG2_SKIP_RD = 16384;
    public static final int CODEC_FLAG2_CHUNKS = 32768;
    public static final int CODEC_FLAG2_NON_LINEAR_QUANT = 65536;
    public static final int CODEC_FLAG2_BIT_RESERVOIR = 131072;
    public static final int CODEC_FLAG2_MBTREE = 262144;
    public static final int CODEC_FLAG2_PSY = 524288;
    public static final int CODEC_FLAG2_SSIM = 0x100000;
    public static final int CODEC_FLAG2_INTRA_REFRESH = 0x200000;
    public static final int FF_BUG_AUTODETECT = 1;
    public static final int FF_BUG_OLD_MSMPEG4 = 2;
    public static final int FF_BUG_XVID_ILACE = 4;
    public static final int FF_BUG_UMP4 = 8;
    public static final int FF_BUG_NO_PADDING = 16;
    public static final int FF_BUG_AMV = 32;
    public static final int FF_BUG_AC_VLC = 0;
    public static final int FF_BUG_QPEL_CHROMA = 64;
    public static final int FF_BUG_STD_QPEL = 128;
    public static final int FF_BUG_QPEL_CHROMA2 = 256;
    public static final int FF_BUG_DIRECT_BLOCKSIZE = 512;
    public static final int FF_BUG_EDGE = 1024;
    public static final int FF_BUG_HPEL_CHROMA = 2048;
    public static final int FF_BUG_DC_CLIP = 4096;
    public static final int FF_BUG_MS = 8192;
    public static final int FF_BUG_TRUNCATED = 16384;
    public static final int AVDISCARD_NONE = -16;
    public static final int AVDISCARD_DEFAULT = 0;
    public static final int AVDISCARD_NONREF = 8;
    public static final int AVDISCARD_BIDIR = 16;
    public static final int AVDISCARD_NONKEY = 32;
    public static final int AVDISCARD_ALL = 48;
    public static final int AVCOL_RANGE_UNSPECIFIED = 0;
    public static final int AVCOL_RANGE_MPEG = 1;
    public static final int AVCOL_RANGE_JPEG = 2;
    public static final int AVCOL_RANGE_NB = 3;
    public static final int AVCOL_PRI_BT709 = 1;
    public static final int AVCOL_PRI_UNSPECIFIED = 2;
    public static final int AVCOL_PRI_BT470M = 4;
    public static final int AVCOL_PRI_BT470BG = 5;
    public static final int AVCOL_PRI_SMPTE170M = 6;
    public static final int AVCOL_PRI_SMPTE240M = 7;
    public static final int AVCOL_PRI_FILM = 8;
    public static final int AVCOL_PRI_NB = 9;
    public static final int AVCOL_TRC_BT709 = 1;
    public static final int AVCOL_TRC_UNSPECIFIED = 2;
    public static final int AVCOL_TRC_GAMMA22 = 4;
    public static final int AVCOL_TRC_GAMMA28 = 5;
    public static final int AVCOL_TRC_NB = 6;
    public static final int AVCOL_SPC_RGB = 0;
    public static final int AVCOL_SPC_BT709 = 1;
    public static final int AVCOL_SPC_UNSPECIFIED = 2;
    public static final int AVCOL_SPC_FCC = 4;
    public static final int AVCOL_SPC_BT470BG = 5;
    public static final int AVCOL_SPC_SMPTE170M = 6;
    public static final int AVCOL_SPC_SMPTE240M = 7;
    public static final int AVCOL_SPC_NB = 8;
    public static final int PIX_FMT_NONE = -1;
    public static final int PIX_FMT_YUV420P = 1;
    public static final int PIX_FMT_YUYV422 = 2;
    public static final int PIX_FMT_RGB24 = 3;
    public static final int PIX_FMT_BGR24 = 4;
    public static final int PIX_FMT_YUV422P = 5;
    public static final int PIX_FMT_YUV444P = 6;
    public static final int PIX_FMT_YUV410P = 7;
    public static final int PIX_FMT_YUV411P = 8;
    public static final int PIX_FMT_GRAY8 = 9;
    public static final int PIX_FMT_MONOWHITE = 10;
    public static final int PIX_FMT_MONOBLACK = 11;
    public static final int PIX_FMT_PAL8 = 12;
    public static final int PIX_FMT_YUVJ420P = 13;
    public static final int PIX_FMT_YUVJ422P = 14;
    public static final int PIX_FMT_YUVJ444P = 15;
    public static final int PIX_FMT_XVMC_MPEG2_MC = 16;
    public static final int PIX_FMT_XVMC_MPEG2_IDCT = 17;
    public static final int PIX_FMT_UYVY422 = 18;
    public static final int PIX_FMT_UYYVYY411 = 19;
    public static final int PIX_FMT_BGR8 = 20;
    public static final int PIX_FMT_BGR4 = 21;
    public static final int PIX_FMT_BGR4_BYTE = 22;
    public static final int PIX_FMT_RGB8 = 23;
    public static final int PIX_FMT_RGB4 = 24;
    public static final int PIX_FMT_RGB4_BYTE = 25;
    public static final int PIX_FMT_NV12 = 26;
    public static final int PIX_FMT_NV21 = 27;
    public static final int PIX_FMT_ARGB = 28;
    public static final int PIX_FMT_RGBA = 29;
    public static final int PIX_FMT_ABGR = 30;
    public static final int PIX_FMT_BGRA = 31;
    public static final int PIX_FMT_GRAY16BE = 32;
    public static final int PIX_FMT_GRAY16LE = 33;
    public static final int PIX_FMT_YUV440P = 34;
    public static final int PIX_FMT_YUVJ440P = 35;
    public static final int PIX_FMT_YUVA420P = 36;
    public static final int PIX_FMT_VDPAU_H264 = 37;
    public static final int PIX_FMT_VDPAU_MPEG1 = 38;
    public static final int PIX_FMT_VDPAU_MPEG2 = 39;
    public static final int PIX_FMT_VDPAU_WMV3 = 40;
    public static final int PIX_FMT_VDPAU_VC1 = 41;
    public static final int PIX_FMT_RGB48BE = 42;
    public static final int PIX_FMT_RGB48LE = 43;
    public static final int PIX_FMT_RGB565BE = 44;
    public static final int PIX_FMT_RGB565LE = 45;
    public static final int PIX_FMT_RGB555BE = 46;
    public static final int PIX_FMT_RGB555LE = 47;
    public static final int PIX_FMT_BGR565BE = 48;
    public static final int PIX_FMT_BGR565LE = 49;
    public static final int PIX_FMT_BGR555BE = 50;
    public static final int PIX_FMT_BGR555LE = 51;
    public static final int PIX_FMT_VAAPI_MOCO = 52;
    public static final int PIX_FMT_VAAPI_IDCT = 53;
    public static final int PIX_FMT_VAAPI_VLD = 54;
    public static final int PIX_FMT_YUV420P16LE = 55;
    public static final int PIX_FMT_YUV420P16BE = 56;
    public static final int PIX_FMT_YUV422P16LE = 57;
    public static final int PIX_FMT_YUV422P16BE = 58;
    public static final int PIX_FMT_YUV444P16LE = 59;
    public static final int PIX_FMT_YUV444P16BE = 60;
    public static final int PIX_FMT_VDPAU_MPEG4 = 61;
    public static final int PIX_FMT_DXVA2_VLD = 62;
    public static final int PIX_FMT_RGB444BE = 63;
    public static final int PIX_FMT_RGB444LE = 64;
    public static final int PIX_FMT_BGR444BE = 65;
    public static final int PIX_FMT_BGR444LE = 66;
    public static final int PIX_FMT_Y400A = 67;
    public static final int PIX_FMT_NB = 68;
    public static final int[] ff_hwaccel_pixfmt_list_420;
    public static final int SLICE_FLAG_CODED_ORDER = 1;
    public static final int SLICE_FLAG_ALLOW_FIELD = 2;
    public static final int SLICE_FLAG_ALLOW_PLANE = 4;
    public static final int EDGE_WIDTH = 16;
    public static final long AV_NOPTS_VALUE = Long.MIN_VALUE;
    public static final int AV_TIME_BASE = 1000000;
    public static final int INTERNAL_BUFFER_SIZE = 32;
    public static final int STRIDE_ALIGN = 8;
    public static final int AVCHROMA_LOC_LEFT = 1;
    public static final int FF_INPUT_BUFFER_PADDING_SIZE = 80;
    public static final int CONFIG_GRAY = 0;
    public static final int MAX_PICTURE_COUNT = 32;
    public static final int FMT_H264 = 4;
    public static final int FF_COMPLIANCE_VERY_STRICT = 2;
    public static final int FF_COMPLIANCE_STRICT = 1;
    public static final int FF_COMPLIANCE_NORMAL = 0;
    public H264Decoder codec;
    public int strict_std_compliance;
    public int alternate_scan;
    public int qscale;
    public int[] block_wrap = new int[6];
    public int codec_tag;
    public int stream_codec_tag;
    public int frame_size;
    public int frame_number;
    public static int MV_DIR_FORWARD;
    public static int MV_DIR_BACKWARD;
    public static int MV_DIR_DIRECT;
    public int mv_dir;
    public ScanTable intra_scantable = new ScanTable();
    public ScanTable intra_h_scantable = new ScanTable();
    public ScanTable intra_v_scantable = new ScanTable();
    public ScanTable inter_scantable = new ScanTable();
    public int chroma_sample_location;
    public int[][] dct_error_sum;
    public int[] dct_count = new int[2];
    public int[][] dct_offset;
    public int mb_x;
    public int mb_y;
    public int mb_skip_run;
    public int mb_intra;
    public int thread_count = 1;
    public int dropable;
    public int pict_type;
    public int width;
    public int height;
    public AVRational sample_aspect_ratio;
    public int decode;
    public AVRational time_base;
    public int idct_algo;
    public int skip_loop_filter;
    public int color_range;
    public int color_primaries;
    public int profile;
    public int color_trc;
    public int colorspace;
    public int[] mb_index2xy;
    public int level;
    public int refs;
    public int out_format;
    public int pix_fmt;
    public int error_recognition;
    public int context_initialized;
    public int input_picture_number;
    public int coded_picture_number;
    public int picture_number;
    public int picture_in_gop_number;
    public int b_frames_since_non_b;
    public int user_specified_pts;
    public int mb_width;
    public int mb_height;
    public int mb_stride;
    public int b8_stride;
    public int b4_stride;
    public int h_edge_pos;
    public int v_edge_pos;
    public int mb_num;
    public int linesize;
    public int uvlinesize;
    public int f_code;
    public int b_code;
    public int bitstream_buffer_size;
    public int chroma_x_shift;
    public int chroma_y_shift;
    public int low_delay;
    public int picture_structure;
    public int data_partitioning;
    public int partitioned_frame;
    public int codec_id;
    public int first_slice;
    public int first_field;
    public int hurry_up;
    public InternalBuffer[] internal_buffer;
    public int slice_flags;
    public int ticks_per_frame;
    public GetBitContext gb = new GetBitContext();
    public DSPContext dsp = new DSPContext();
    public MotionEstContext me = new MotionEstContext();
    public int resync_mb_x;
    public int resync_mb_y;
    public int hwaccel = 0;
    public int closed_gop;
    public int pp_time;
    public int pb_time;
    public int skip_frame = 0;
    public int flags;
    public int flags2;
    public int workaround_bugs;
    public int[] allocated_edge_emu_buffer;
    public int edge_emu_buffer_offset;
    public int[] obmc_scratchpad;
    public int intra_only;
    public int unrestricted_mv;
    public int quarter_sample;
    public int last_pict_type;
    public int[] last_lambda_for = new int[5];
    public int last_non_b_pict_type;
    public int[] prev_pict_types;
    public static final int PREV_PICT_TYPES_BUFFER_SIZE = 256;
    public int mb_skipped;
    public int[] mbskip_table;
    public int[] mbintra_table;
    public int lowres;
    public int coded_width;
    public int coded_height;
    public int start_mb_y;
    public int end_mb_y;
    public MpegEncContext[] thread_context = new MpegEncContext[1];
    public AVFrame coded_frame;
    public ParseContext parse_context = new ParseContext();
    public int[] rd_scratchpad;
    public int obmc_scratchpad_offset;
    public int[] b_scratchpad;
    public AVFrame[] picture;
    public AVFrame current_picture = new AVFrame();
    public int internal_buffer_count;
    public AVFrame last_picture = new AVFrame();
    public AVFrame next_picture = new AVFrame();
    public int top_field_first;
    public AVPacket pkt;
    public AVFrame current_picture_ptr;
    public AVFrame last_picture_ptr;
    public AVFrame next_picture_ptr;
    public int broken_link;
    public H264Context priv_data;
    public int mv_type;
    public int[][] visualization_buffer;
    public int error_count;
    public int[] error_status_table;
    public long reordered_opaque;
    public int progressive_frame;
    public int progressive_sequence;
    public int[] y_dc_scale_table;
    public int[] c_dc_scale_table;
    public int[] chroma_qscale_table;
    public int[] pblocks_offset;
    public short[][] block;
    public short[][][] blocks;
    public int[] extradata;
    public int extradata_size;

    static {
        int[] nArray = new int[32];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = 5;
        nArray[6] = 6;
        nArray[7] = 7;
        nArray[8] = 8;
        nArray[9] = 9;
        nArray[10] = 10;
        nArray[11] = 11;
        nArray[12] = 12;
        nArray[13] = 13;
        nArray[14] = 14;
        nArray[15] = 15;
        nArray[16] = 16;
        nArray[17] = 17;
        nArray[18] = 18;
        nArray[19] = 19;
        nArray[20] = 20;
        nArray[21] = 21;
        nArray[22] = 22;
        nArray[23] = 23;
        nArray[24] = 24;
        nArray[25] = 25;
        nArray[26] = 26;
        nArray[27] = 27;
        nArray[28] = 28;
        nArray[29] = 29;
        nArray[30] = 30;
        nArray[31] = 31;
        ff_default_chroma_qscale_table = nArray;
        ff_mpeg1_dc_scale_table = new int[]{8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8};
        ff_hwaccel_pixfmt_list_420 = new int[]{62, 54, 1, -1};
        MV_DIR_FORWARD = 1;
        MV_DIR_BACKWARD = 2;
        MV_DIR_DIRECT = 4;
    }

    public static int get_format(int[] fmt) {
        return 1;
    }

    public static int av_image_check_size(int w, int h, int log_offset, MpegEncContext log_ctx) {
        if (w > 0 && h > 0 && (long)(w + 128) * (long)(h + 128) < 0xFFFFFFFL) {
            return 0;
        }
        return -1;
    }

    public int get_consumed_bytes(int pos, int buf_size) {
        if (pos == 0) {
            pos = 1;
        }
        if (pos + 10 > buf_size) {
            pos = buf_size;
        }
        return pos;
    }

    public void ff_init_scantable(int[] permutation, ScanTable st, int[] src_scantable) {
        int j;
        st.scantable = src_scantable;
        int i = 0;
        while (i < 64) {
            j = src_scantable[i];
            st.permutated[i] = permutation[j];
            ++i;
        }
        int end = -1;
        i = 0;
        while (i < 64) {
            j = st.permutated[i];
            if (j > end) {
                end = j;
            }
            st.raster_end[i] = end;
            ++i;
        }
    }

    public int ff_dct_common_init() {
        if (this.alternate_scan != 0) {
            this.ff_init_scantable(this.dsp.idct_permutation, this.inter_scantable, H264Context.ff_alternate_vertical_scan);
            this.ff_init_scantable(this.dsp.idct_permutation, this.intra_scantable, H264Context.ff_alternate_vertical_scan);
        } else {
            this.ff_init_scantable(this.dsp.idct_permutation, this.inter_scantable, H264Context.ff_zigzag_direct);
            this.ff_init_scantable(this.dsp.idct_permutation, this.intra_scantable, H264Context.ff_zigzag_direct);
        }
        this.ff_init_scantable(this.dsp.idct_permutation, this.intra_h_scantable, H264Context.ff_alternate_horizontal_scan);
        this.ff_init_scantable(this.dsp.idct_permutation, this.intra_v_scantable, H264Context.ff_alternate_vertical_scan);
        return 0;
    }

    public void avcodec_align_dimensions2(int[] widthheight, int[] linesize_align) {
        int w_align = 1;
        int h_align = 1;
        switch (this.pix_fmt) {
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 9: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                w_align = 16;
                h_align = 16;
                if (this.codec_id != 2 && this.codec_id != 8 && this.codec_id != 110 && this.codec_id != 103 && this.codec_id != 28) break;
                h_align = 32;
                break;
            }
            case 8: 
            case 19: {
                w_align = 32;
                h_align = 8;
                break;
            }
            case 7: {
                if (this.codec_id == 23) {
                    w_align = 64;
                    h_align = 64;
                }
            }
            case 12: 
            case 20: 
            case 23: {
                if (this.codec_id != 50) break;
                w_align = 4;
                h_align = 4;
                break;
            }
            case 4: {
                if (this.codec_id != 54 && this.codec_id != 55) break;
                w_align = 4;
                h_align = 4;
                break;
            }
            default: {
                w_align = 1;
                h_align = 1;
            }
        }
        widthheight[0] = widthheight[0] + w_align - 1 & ~(w_align - 1);
        widthheight[1] = widthheight[1] + h_align - 1 & ~(h_align - 1);
        if (this.codec_id == 28 || this.lowres != 0) {
            widthheight[1] = widthheight[1] + 2;
        }
        linesize_align[3] = 8;
        linesize_align[2] = 8;
        linesize_align[1] = 8;
        linesize_align[0] = 8;
    }

    public void av_image_fill_max_pixsteps(int[] max_pixsteps, int[] max_pixstep_comps, AVPixFmtDescriptor pixdesc) {
        Arrays.fill(max_pixsteps, 0);
        if (max_pixstep_comps != null) {
            Arrays.fill(max_pixstep_comps, 0);
        }
        int i = 0;
        while (i < 4) {
            AVComponentDescriptor comp = pixdesc.comp[i];
            if (comp.step_minus1 + 1 > max_pixsteps[comp.plane]) {
                max_pixsteps[comp.plane] = comp.step_minus1 + 1;
                if (max_pixstep_comps != null) {
                    max_pixstep_comps[comp.plane] = i;
                }
            }
            ++i;
        }
    }

    public int av_image_fill_linesizes(int[] linesizes, int pix_fmt, int width) {
        AVPixFmtDescriptor desc = ImageUtils.av_pix_fmt_descriptors[pix_fmt];
        int[] max_step = new int[4];
        int[] max_step_comp = new int[4];
        Arrays.fill(linesizes, 0);
        if (pix_fmt >= 68 || (desc.flags & 8) != 0) {
            return -1;
        }
        if ((desc.flags & 4) != 0) {
            if (width > 0x7FFFFFF8 / (desc.comp[0].step_minus1 + 1)) {
                return -1;
            }
            linesizes[0] = width * (desc.comp[0].step_minus1 + 1) + 7 >> 3;
            return 0;
        }
        this.av_image_fill_max_pixsteps(max_step, max_step_comp, desc);
        int i = 0;
        while (i < 4) {
            int s = max_step_comp[i] == 1 || max_step_comp[i] == 2 ? desc.log2_chroma_w : 0;
            int shifted_w = width + (1 << s) - 1 >> s;
            if (max_step[i] > Integer.MAX_VALUE / shifted_w) {
                return -1;
            }
            linesizes[i] = max_step[i] * shifted_w;
            ++i;
        }
        return 0;
    }

    public int av_image_fill_pointers(int[][] data_base, int[] data_offset, int pix_fmt, int height, int[] ptr, int[] linesizes) {
        int[] size = new int[4];
        int[] has_plane = new int[4];
        AVPixFmtDescriptor desc = ImageUtils.av_pix_fmt_descriptors[pix_fmt];
        int k = 0;
        while (k < 4) {
            data_base[k] = null;
            data_offset[k] = 0;
            ++k;
        }
        if (pix_fmt >= 68 || (desc.flags & 8) != 0) {
            return -1;
        }
        data_base[0] = ptr;
        data_offset[0] = 0;
        if (linesizes[0] > 0x7FFFFBFF / height) {
            return -1;
        }
        size[0] = linesizes[0] * height;
        if ((desc.flags & 2) != 0) {
            size[0] = size[0] + 3 & 0xFFFFFFFC;
            data_base[1] = ptr;
            data_offset[1] = size[0];
            return size[0] + 1024;
        }
        int i = 0;
        while (i < 4) {
            has_plane[desc.comp[i].plane] = 1;
            ++i;
        }
        int total_size = size[0];
        i = 1;
        while (has_plane[i] != 0 && i < 4) {
            int s = i == 1 || i == 2 ? desc.log2_chroma_h : 0;
            data_base[i] = data_base[i - 1];
            data_offset[i] = data_offset[i - 1] + size[i - 1];
            int h = height + (1 << s) - 1 >> s;
            if (linesizes[i] > Integer.MAX_VALUE / h) {
                return -1;
            }
            size[i] = h * linesizes[i];
            if (total_size > Integer.MAX_VALUE - size[i]) {
                return -1;
            }
            total_size += size[i];
            ++i;
        }
        return total_size;
    }

    public int ff_set_systematic_pal2(int[] pal, int pal_offset, int pix_fmt) {
        int i = 0;
        while (i < 256) {
            int b;
            int g;
            int r;
            switch (pix_fmt) {
                case 23: {
                    r = (i >> 5) * 36;
                    g = (i >> 2 & 7) * 36;
                    b = (i & 3) * 85;
                    break;
                }
                case 20: {
                    b = (i >> 6) * 85;
                    g = (i >> 3 & 7) * 36;
                    r = (i & 7) * 36;
                    break;
                }
                case 25: {
                    r = (i >> 3) * 255;
                    g = (i >> 1 & 3) * 85;
                    b = (i & 1) * 255;
                    break;
                }
                case 22: {
                    b = (i >> 3) * 255;
                    g = (i >> 1 & 3) * 85;
                    r = (i & 1) * 255;
                    break;
                }
                case 9: {
                    b = g = i;
                    r = g;
                    break;
                }
                default: {
                    return -1;
                }
            }
            pal[pal_offset + i * 4 + 0] = b;
            pal[pal_offset + i * 4 + 1] = g;
            pal[pal_offset + i * 4 + 2] = r;
            pal[pal_offset + i * 4 + 3] = 0;
            ++i;
        }
        return 0;
    }

    public int get_buffer(AVFrame pic) {
        int i;
        int w = this.width;
        int h = this.height;
        if (pic.data_base[0] != null) {
            return -1;
        }
        if (this.internal_buffer_count >= 32) {
            return -1;
        }
        if (MpegEncContext.av_image_check_size(w, h, 0, this) != 0) {
            return -1;
        }
        if (this.internal_buffer == null) {
            this.internal_buffer = new InternalBuffer[33];
            i = 0;
            while (i < 33) {
                this.internal_buffer[i] = new InternalBuffer();
                ++i;
            }
        }
        InternalBuffer buf = this.internal_buffer[this.internal_buffer_count];
        ++this.internal_buffer[32].last_pic_num;
        if (buf.base[0] != null && (buf.width != w || buf.height != h || buf.pix_fmt != this.pix_fmt)) {
            i = 0;
            while (i < 4) {
                buf.base[i] = null;
                buf.data_offset[i] = 0;
                ++i;
            }
        }
        if (buf.base[0] != null) {
            pic.age = this.internal_buffer[32].last_pic_num - buf.last_pic_num;
            buf.last_pic_num = this.internal_buffer[32].last_pic_num;
        } else {
            int unaligned;
            int[] size = new int[4];
            AVPicture picture = new AVPicture();
            int[] stride_align = new int[4];
            int h_chroma_shift = ImageUtils.av_pix_fmt_descriptors[this.pix_fmt].log2_chroma_w;
            int v_chroma_shift = ImageUtils.av_pix_fmt_descriptors[this.pix_fmt].log2_chroma_h;
            int[] param = new int[]{w, h};
            this.avcodec_align_dimensions2(param, stride_align);
            w = param[0];
            h = param[1];
            pic.imageWidthWOEdge = w;
            pic.imageHeightWOEdge = h;
            if ((this.flags & 0x4000) == 0) {
                w += 32;
                h += 32;
            }
            pic.imageWidth = w;
            pic.imageHeight = h;
            do {
                this.av_image_fill_linesizes(picture.linesize, this.pix_fmt, w);
                w += w & ~(w - 1);
                unaligned = 0;
                i = 0;
                while (i < 4) {
                    unaligned |= picture.linesize[i] % stride_align[i];
                    ++i;
                }
            } while (unaligned != 0);
            int tmpsize = this.av_image_fill_pointers(picture.data_base, picture.data_offset, this.pix_fmt, h, null, picture.linesize);
            if (tmpsize < 0) {
                return -1;
            }
            i = 0;
            while (i < 3 && picture.data_offset[i + 1] != 0) {
                size[i] = picture.data_offset[i + 1] - picture.data_offset[i];
                ++i;
            }
            size[i] = tmpsize - (picture.data_offset[i] - picture.data_offset[0]);
            buf.last_pic_num = -1073741824;
            int k = 0;
            while (k < buf.base.length) {
                buf.base[k] = null;
                ++k;
            }
            k = 0;
            while (k < buf.data_offset.length) {
                buf.data_offset[k] = 0;
                ++k;
            }
            i = 0;
            while (i < 4 && size[i] != 0) {
                int h_shift = i == 0 ? 0 : h_chroma_shift;
                int v_shift = i == 0 ? 0 : v_chroma_shift;
                buf.linesize[i] = picture.linesize[i];
                buf.base[i] = new int[size[i] + 16];
                if (buf.base[i] == null) {
                    return -1;
                }
                Arrays.fill(buf.base[i], 0, size[i], 128);
                buf.data_offset[i] = (this.flags & 0x4000) != 0 || size[2] == 0 ? 0 : (buf.linesize[i] * 16 >> v_shift) + (16 >> h_shift) + stride_align[i] - 1 & ~(stride_align[i] - 1);
                ++i;
            }
            if (size[1] != 0 && size[2] == 0) {
                this.ff_set_systematic_pal2(buf.base[1], buf.data_offset[1], this.pix_fmt);
            }
            buf.width = this.width;
            buf.height = this.height;
            buf.pix_fmt = this.pix_fmt;
            pic.age = 0x40000000;
        }
        pic.type = 1;
        i = 0;
        while (i < 4) {
            pic.base[i] = buf.base[i];
            pic.data_base[i] = buf.base[i];
            pic.data_offset[i] = buf.data_offset[i];
            pic.linesize[i] = buf.linesize[i];
            ++i;
        }
        ++this.internal_buffer_count;
        pic.pkt_pts = this.pkt != null ? this.pkt.pts : Long.MIN_VALUE;
        pic.reordered_opaque = this.reordered_opaque;
        return 0;
    }

    public int alloc_frame_buffer(AVFrame pic) {
        int r = this.get_buffer(pic);
        if (r < 0 || pic.age == 0 || pic.type == 0 || pic.data_base[0] == null) {
            return -1;
        }
        if (this.linesize != 0 && (this.linesize != pic.linesize[0] || this.uvlinesize != pic.linesize[1])) {
            this.free_frame_buffer(pic);
            return -1;
        }
        if (pic.linesize[1] != pic.linesize[2]) {
            this.free_frame_buffer(pic);
            return -1;
        }
        return 0;
    }

    public int ff_alloc_picture(AVFrame pic, int shared) {
        int big_mb_num = this.mb_stride * (this.mb_height + 1) + 1;
        int mb_array_size = this.mb_stride * this.mb_height;
        int b4_array_size = this.b4_stride * this.mb_height * 4;
        if (shared != 0) {
            pic.type = 4;
        } else {
            if (this.alloc_frame_buffer(pic) < 0) {
                return -1;
            }
            this.linesize = pic.linesize[0];
            this.uvlinesize = pic.linesize[1];
        }
        if (pic.qscale_table == null) {
            pic.mbskip_table = new int[mb_array_size + 2];
            pic.qscale_table = new int[mb_array_size];
            pic.mb_type_base = new long[big_mb_num + this.mb_stride];
            pic.mb_type_offset = 2 * this.mb_stride + 1;
            if (this.out_format == 4) {
                int i = 0;
                while (i < 2) {
                    pic.motion_val_base[i] = new int[b4_array_size + 4][2];
                    pic.motion_val_offset[i] = 4;
                    pic.ref_index[i] = new int[4 * mb_array_size];
                    ++i;
                }
                pic.motion_subsample_log2 = 2;
            }
            pic.qstride = this.mb_stride;
            pic.pan_scan = new AVPanScan();
        }
        int k = 1;
        while (k < 256) {
            this.prev_pict_types[k] = this.prev_pict_types[k - 1];
            ++k;
        }
        int n = this.prev_pict_types[0] = this.dropable != 0 ? 3 : this.pict_type;
        if (pic.age < 256 && this.prev_pict_types[pic.age] == 3) {
            pic.age = Integer.MAX_VALUE;
        }
        return 0;
    }

    public int ff_find_unused_picture(int shared) {
        if (shared != 0) {
            int i = 0;
            while (i < 32) {
                if (this.picture[i].data_base[0] == null && this.picture[i].type == 0) {
                    return i;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < 32) {
                if (this.picture[i].data_base[0] == null && this.picture[i].type != 0) {
                    return i;
                }
                ++i;
            }
            i = 0;
            while (i < 32) {
                if (this.picture[i].data_base[0] == null) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public int MPV_frame_start() {
        AVFrame pic;
        this.mb_skipped = 0;
        int i = 0;
        while (i < 32) {
            if (this.picture[i].data_base[0] != null && this.picture[i].reference == 0 && this.picture[i].type != 4) {
                this.free_frame_buffer(this.picture[i]);
            }
            ++i;
        }
        if (this.current_picture_ptr != null && this.current_picture_ptr.data_base[0] == null) {
            pic = this.current_picture_ptr;
        } else {
            i = this.ff_find_unused_picture(0);
            pic = this.picture[i];
        }
        pic.reference = 0;
        if (this.dropable == 0) {
            if (this.codec_id == 28) {
                pic.reference = this.picture_structure;
            } else if (this.pict_type != 3) {
                pic.reference = 3;
            }
        }
        pic.coded_picture_number = this.coded_picture_number++;
        if (this.ff_alloc_picture(pic, 0) < 0) {
            return -1;
        }
        this.current_picture_ptr = pic;
        this.current_picture_ptr.top_field_first = this.top_field_first;
        this.current_picture_ptr.interlaced_frame = this.progressive_frame == 0 && this.progressive_sequence == 0 ? 1 : 0;
        this.current_picture_ptr.pict_type = this.pict_type;
        this.current_picture_ptr.key_frame = this.pict_type == 1 ? 1 : 0;
        MpegEncContext.ff_copy_picture(this.current_picture, this.current_picture_ptr);
        if (this.pict_type != 3) {
            this.last_picture_ptr = this.next_picture_ptr;
            if (this.dropable == 0) {
                this.next_picture_ptr = this.current_picture_ptr;
            }
        }
        if (this.last_picture_ptr != null) {
            MpegEncContext.ff_copy_picture(this.last_picture, this.last_picture_ptr);
        }
        if (this.next_picture_ptr != null) {
            MpegEncContext.ff_copy_picture(this.next_picture, this.next_picture_ptr);
        }
        this.error_recognition = 1;
        return 0;
    }

    public static void ff_copy_picture(AVFrame dst, AVFrame src) {
        src.copyTo(dst);
        dst.type = 8;
    }

    public static int ff_is_hwaccel_pix_fmt(int pix_fmt) {
        return ImageUtils.av_pix_fmt_descriptors[pix_fmt].flags & 8;
    }

    public int avcodec_default_get_format(int[] fmt) {
        int i = 0;
        while (fmt[i] != -1 && MpegEncContext.ff_is_hwaccel_pix_fmt(fmt[i]) != 0) {
            ++i;
        }
        return fmt[i];
    }

    public static int init_duplicate_context(MpegEncContext s, MpegEncContext base) {
        s.allocated_edge_emu_buffer = new int[(s.width + 64) * 2 * 21 * 2];
        s.edge_emu_buffer_offset = (s.width + 64) * 2 * 21;
        s.me.scratchpad = new int[(s.width + 64) * 4 * 16 * 2];
        s.me.temp = s.me.scratchpad;
        s.rd_scratchpad = s.me.scratchpad;
        s.b_scratchpad = s.me.scratchpad;
        s.obmc_scratchpad_offset = 16;
        s.blocks = new short[2][12][64];
        s.block = s.blocks[0];
        s.pblocks_offset = new int[12];
        int i = 0;
        while (i < 12) {
            s.pblocks_offset[i] = i;
            ++i;
        }
        return 0;
    }

    public static void free_duplicate_context(MpegEncContext s) {
        if (s == null) {
            return;
        }
        s.allocated_edge_emu_buffer = null;
        s.me.scratchpad = null;
        s.b_scratchpad = null;
        s.rd_scratchpad = null;
        s.me.temp = null;
        s.dct_error_sum = null;
        s.me.map = null;
        s.me.score_map = null;
        s.blocks = null;
        s.block = null;
    }

    public int MPV_common_init() {
        if (this.pix_fmt == -1) {
            return -1;
        }
        if (this.thread_count > 1 || this.thread_count > this.mb_height && this.mb_height != 0) {
            return -1;
        }
        if ((this.width != 0 || this.height != 0) && MpegEncContext.av_image_check_size(this.width, this.height, 0, this) != 0) {
            return -1;
        }
        this.dsp.dsputil_init(this);
        this.ff_dct_common_init();
        this.mb_width = (this.width + 15) / 16;
        this.mb_stride = this.mb_width + 1;
        this.b8_stride = this.mb_width * 2 + 1;
        this.b4_stride = this.mb_width * 4 + 1;
        int mb_array_size = this.mb_height * this.mb_stride;
        this.chroma_x_shift = ImageUtils.av_pix_fmt_descriptors[this.pix_fmt].log2_chroma_w;
        this.chroma_y_shift = ImageUtils.av_pix_fmt_descriptors[this.pix_fmt].log2_chroma_h;
        this.h_edge_pos = this.mb_width * 16;
        this.v_edge_pos = this.mb_height * 16;
        this.mb_num = this.mb_width * this.mb_height;
        this.block_wrap[2] = this.block_wrap[3] = this.b8_stride;
        this.block_wrap[1] = this.block_wrap[3];
        this.block_wrap[0] = this.block_wrap[3];
        this.block_wrap[4] = this.block_wrap[5] = this.mb_stride;
        int y_size = this.b8_stride * (2 * this.mb_height + 1);
        int c_size = this.mb_stride * (this.mb_height + 1);
        int yc_size = y_size + 2 * c_size;
        this.coded_frame = this.current_picture;
        this.mb_index2xy = new int[this.mb_num + 1];
        int y = 0;
        while (y < this.mb_height) {
            int x = 0;
            while (x < this.mb_width) {
                this.mb_index2xy[x + y * this.mb_width] = x + y * this.mb_stride;
                ++x;
            }
            ++y;
        }
        this.mb_index2xy[this.mb_height * this.mb_width] = (this.mb_height - 1) * this.mb_stride + this.mb_width;
        this.picture = new AVFrame[32];
        int i = 0;
        while (i < 32) {
            this.picture[i] = new AVFrame();
            this.picture[i].pts = Long.MIN_VALUE;
            this.picture[i].key_frame = 1;
            ++i;
        }
        this.error_status_table = new int[mb_array_size];
        ErrorResilience.dc_val_base = new int[yc_size];
        ErrorResilience.dc_val[0] = this.b8_stride + 1;
        ErrorResilience.dc_val[1] = y_size + this.mb_stride + 1;
        ErrorResilience.dc_val[2] = ErrorResilience.dc_val[1] + c_size;
        i = 0;
        while (i < yc_size) {
            ErrorResilience.dc_val_base[i] = 1024;
            ++i;
        }
        this.mbintra_table = new int[mb_array_size];
        Arrays.fill(this.mbintra_table, 1);
        this.mbskip_table = new int[mb_array_size + 2];
        this.prev_pict_types = new int[256];
        this.parse_context.state = -1;
        this.context_initialized = 1;
        this.thread_context[0] = this;
        int threads = this.thread_count;
        i = 0;
        while (i < threads) {
            if (MpegEncContext.init_duplicate_context(this.thread_context[i], this) < 0) {
                this.MPV_common_end();
                return -1;
            }
            this.thread_context[i].start_mb_y = (this.mb_height * i + this.thread_count / 2) / this.thread_count;
            this.thread_context[i].end_mb_y = (this.mb_height * (i + 1) + this.thread_count / 2) / this.thread_count;
            ++i;
        }
        return 0;
    }

    public void flush_dpb() {
        H264Context h = this.priv_data;
        int i = 0;
        while (i < 16) {
            if (h.delayed_pic[i] != null) {
                h.delayed_pic[i].reference = 0;
            }
            h.delayed_pic[i] = null;
            ++i;
        }
        h.outputed_poc = Integer.MIN_VALUE;
        h.prev_interlaced_frame = 1;
        h.idr();
        if (h.s.current_picture_ptr != null) {
            h.s.current_picture_ptr.reference = 0;
        }
        h.s.first_field = 0;
        SEIDecoder.ff_h264_reset_sei(h);
        this.ff_mpeg_flush();
    }

    public void release_buffer(AVFrame pic) {
        InternalBuffer buf = null;
        int i = 0;
        while (i < this.internal_buffer_count) {
            buf = this.internal_buffer[i];
            if (buf.base[0] == pic.data_base[0] && buf.data_offset[0] == pic.data_offset[0]) break;
            ++i;
        }
        --this.internal_buffer_count;
        InternalBuffer last = this.internal_buffer[this.internal_buffer_count];
        InternalBuffer tmp = new InternalBuffer();
        buf.copyInto(tmp);
        last.copyInto(buf);
        tmp.copyInto(last);
        i = 0;
        while (i < 4) {
            pic.data_base[i] = null;
            pic.data_offset[i] = 0;
            ++i;
        }
    }

    public void free_frame_buffer(AVFrame pic) {
        this.release_buffer(pic);
    }

    public void ff_mpeg_flush() {
        MpegEncContext s = this;
        if (s == null || s.picture == null) {
            return;
        }
        int i = 0;
        while (i < 32) {
            if (s.picture[i].data_base[0] != null && (s.picture[i].type == 1 || s.picture[i].type == 2)) {
                s.free_frame_buffer(s.picture[i]);
            }
            ++i;
        }
        s.next_picture_ptr = null;
        s.last_picture_ptr = null;
        s.current_picture_ptr = null;
        s.mb_y = 0;
        s.mb_x = 0;
        s.closed_gop = 0;
        s.parse_context.state = -1;
        s.parse_context.frame_start_found = 0;
        s.parse_context.overread = 0;
        s.parse_context.overread_index = 0;
        s.parse_context.index = 0;
        s.parse_context.last_index = 0;
        s.bitstream_buffer_size = 0;
        s.pp_time = 0;
    }

    public void MPV_common_end() {
        int i = 0;
        while (i < this.thread_count) {
            ++i;
        }
        this.parse_context.buffer_base = null;
        this.parse_context.buffer_size = 0;
        if (this.picture != null) {
            i = 0;
            while (i < 32) {
                ++i;
            }
        }
        this.picture = null;
        this.context_initialized = 0;
        this.current_picture_ptr = null;
        this.next_picture_ptr = null;
        this.last_picture_ptr = null;
        this.uvlinesize = 0;
        this.linesize = 0;
    }

    public void MPV_frame_end() {
        if (this.unrestricted_mv != 0 && this.current_picture.reference != 0 && this.intra_only == 0 && (this.flags & 0x4000) == 0) {
            this.dsp.draw_edges(this.current_picture.data_base[0], this.current_picture.data_offset[0], this.linesize, this.h_edge_pos, this.v_edge_pos, 16);
            this.dsp.draw_edges(this.current_picture.data_base[1], this.current_picture.data_offset[1], this.uvlinesize, this.h_edge_pos >> 1, this.v_edge_pos >> 1, 8);
            this.dsp.draw_edges(this.current_picture.data_base[2], this.current_picture.data_offset[2], this.uvlinesize, this.h_edge_pos >> 1, this.v_edge_pos >> 1, 8);
        }
        this.last_pict_type = this.pict_type;
        this.last_lambda_for[this.pict_type] = this.current_picture_ptr.quality;
        if (this.pict_type != 3) {
            this.last_non_b_pict_type = this.pict_type;
        }
        this.coded_frame = this.current_picture_ptr;
    }

    public void avcodec_set_dimensions(int width, int height) {
        this.coded_width = width;
        this.coded_height = height;
        this.width = -(-width >> this.lowres);
        this.height = -(-height >> this.lowres);
    }

    public int ff_h264_decode_end() {
        H264Context h = this.priv_data;
        h.ff_h264_free_context();
        this.MPV_common_end();
        return 0;
    }

    public void MPV_common_defaults() {
        this.c_dc_scale_table = ff_mpeg1_dc_scale_table;
        this.y_dc_scale_table = ff_mpeg1_dc_scale_table;
        this.chroma_qscale_table = ff_default_chroma_qscale_table;
        this.progressive_frame = 1;
        this.progressive_sequence = 1;
        this.picture_structure = 3;
        this.coded_picture_number = 0;
        this.picture_number = 0;
        this.input_picture_number = 0;
        this.picture_in_gop_number = 0;
        this.f_code = 1;
        this.b_code = 1;
    }

    public int ff_h264_decode_init() {
        H264Context h = this.priv_data;
        this.MPV_common_defaults();
        h.common_init(this);
        this.out_format = 4;
        this.quarter_sample = 1;
        if (this.has_b_frames == 0) {
            this.low_delay = 1;
        }
        this.chroma_sample_location = 1;
        h.cavlc.ff_h264_decode_init_vlc();
        h.thread_context[0] = h;
        h.outputed_poc = Integer.MIN_VALUE;
        h.prev_poc_msb = 65536;
        h.x264_build = -1;
        SEIDecoder.ff_h264_reset_sei(h);
        if (this.codec_id == 28) {
            if (this.ticks_per_frame == 1) {
                this.time_base.den *= 2;
            }
            this.ticks_per_frame = 2;
        }
        if (this.extradata_size > 0 && this.extradata != null && h.ff_h264_decode_extradata() != 0) {
            return -1;
        }
        if (h.sps.bitstream_restriction_flag != 0 && this.has_b_frames < h.sps.num_reorder_frames) {
            this.has_b_frames = h.sps.num_reorder_frames;
            this.low_delay = 0;
        }
        return 0;
    }

    public void ff_draw_horiz_band(int y, int h) {
    }

    public static MpegEncContext avcodec_alloc_context() {
        MpegEncContext s = new MpegEncContext();
        s.time_base = new AVRational(0, 1);
        s.sample_aspect_ratio = new AVRational(0, 1);
        s.pix_fmt = -1;
        s.reordered_opaque = Long.MIN_VALUE;
        return s;
    }

    public int avcodec_open(H264Decoder codec) {
        int ret = -1;
        this.priv_data = new H264Context();
        if (this.coded_width != 0 && this.coded_height != 0) {
            this.avcodec_set_dimensions(this.coded_width, this.coded_height);
        } else if (this.width != 0 && this.height != 0) {
            this.avcodec_set_dimensions(this.width, this.height);
        }
        if (!(this.coded_width == 0 && this.coded_height == 0 && this.width == 0 && this.height == 0 || MpegEncContext.av_image_check_size(this.coded_width, this.coded_height, 0, this) >= 0 && MpegEncContext.av_image_check_size(this.width, this.height, 0, this) >= 0)) {
            this.avcodec_set_dimensions(0, 0);
        }
        this.codec = codec;
        this.codec_id = codec.id;
        this.frame_number = 0;
        if (this.codec.max_lowres < this.lowres) {
            return ret;
        }
        ret = this.codec.init(this);
        if (ret < 0) {
            return ret;
        }
        ret = 0;
        return ret;
    }

    public void avcodec_default_free_buffers() {
        if (this.internal_buffer == null) {
            return;
        }
        int i = 0;
        while (i < 32) {
            InternalBuffer buf = this.internal_buffer[i];
            int j = 0;
            while (j < 4) {
                buf.base[j] = null;
                buf.data_offset[j] = 0;
                ++j;
            }
            ++i;
        }
        this.internal_buffer = null;
        this.internal_buffer_count = 0;
    }

    public int avcodec_close() {
        if (this.codec != null) {
            this.codec.close(this);
        }
        this.avcodec_default_free_buffers();
        this.coded_frame = null;
        this.priv_data = null;
        this.codec = null;
        return 0;
    }

    public int avcodec_decode_video2(AVFrame picture, int[] got_picture_ptr, AVPacket avpkt) {
        int ret;
        got_picture_ptr[0] = 0;
        if ((this.coded_width != 0 || this.coded_height != 0) && MpegEncContext.av_image_check_size(this.coded_width, this.coded_height, 0, this) != 0) {
            return -1;
        }
        this.pkt = avpkt;
        if ((this.codec.capabilities & 0x20) != 0 || avpkt.size != 0) {
            ret = this.codec.decode(this, picture, got_picture_ptr, avpkt);
            picture.pkt_dts = avpkt.dts;
            if (got_picture_ptr[0] != 0) {
                ++this.frame_number;
            }
        } else {
            ret = 0;
        }
        return ret;
    }
}

