/*
 * Decompiled with CFR 0.152.
 */
package com.twilight.h264.player;

import com.twilight.h264.decoder.AVFrame;
import java.awt.image.BufferedImage;

public class FrameUtils {
    public static BufferedImage imageFromFrame(AVFrame f) {
        BufferedImage bi = new BufferedImage(f.imageWidth, f.imageHeight, 2);
        int[] rgb = new int[f.imageWidth * f.imageHeight];
        FrameUtils.YUV2RGB(f, rgb);
        int j = 0;
        while (j < f.imageHeight) {
            int off = j * f.imageWidth;
            int i = 0;
            while (i < f.imageWidth) {
                bi.setRGB(i, j, rgb[off + i]);
                ++i;
            }
            ++j;
        }
        return bi;
    }

    public static void YUV2RGB(AVFrame f, int[] rgb) {
        int[] luma = f.data_base[0];
        int[] cb = f.data_base[1];
        int[] cr = f.data_base[2];
        int stride = f.linesize[0];
        int strideChroma = f.linesize[1];
        int y = 0;
        while (y < f.imageHeight) {
            int lineOffLuma = y * stride;
            int lineOffChroma = (y >> 1) * strideChroma;
            int x = 0;
            while (x < f.imageWidth) {
                int c = luma[lineOffLuma + x] - 16;
                int d = cb[lineOffChroma + (x >> 1)] - 128;
                int e = cr[lineOffChroma + (x >> 1)] - 128;
                int red = 298 * c + 409 * e + 128 >> 8;
                red = red < 0 ? 0 : (red > 255 ? 255 : red);
                int green = 298 * c - 100 * d - 208 * e + 128 >> 8;
                green = green < 0 ? 0 : (green > 255 ? 255 : green);
                int blue = 298 * c + 516 * d + 128 >> 8;
                blue = blue < 0 ? 0 : (blue > 255 ? 255 : blue);
                int alpha = 255;
                rgb[lineOffLuma + x] = alpha << 24 | (red & 0xFF) << 16 | (green & 0xFF) << 8 | blue & 0xFF;
                ++x;
            }
            ++y;
        }
    }
}

