/*
 * Decompiled with CFR 0.152.
 */
package com.ullink.rxscheduler.cron;

import com.ullink.rxscheduler.cron.RxCronScheduler;
import com.ullink.rxscheduler.cron.calendar.Calendar;
import com.ullink.rxscheduler.cron.calendar.CronExpression;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import rx.Scheduler;
import rx.Subscription;
import rx.subscriptions.Subscriptions;
import rx.util.functions.Action0;
import rx.util.functions.Func2;

public class RxCronForwardingScheduler
extends Scheduler
implements RxCronScheduler {
    private final Scheduler underlying;

    public RxCronForwardingScheduler(Scheduler underlying) {
        this.underlying = underlying;
    }

    public Subscription schedule(Action0 action) {
        return this.underlying.schedule(action);
    }

    public <T> Subscription schedule(T state, Func2<? super Scheduler, ? super T, ? extends Subscription> action) {
        return this.underlying.schedule(state, action);
    }

    public Subscription schedule(Action0 action, long dueTime, TimeUnit unit) {
        return this.underlying.schedule(action, dueTime, unit);
    }

    public <T> Subscription schedule(T state, Func2<? super Scheduler, ? super T, ? extends Subscription> action, long dueTime, TimeUnit unit) {
        return this.underlying.schedule(state, action, dueTime, unit);
    }

    public Subscription schedulePeriodically(Action0 action, long initialDelay, long period, TimeUnit unit) {
        return this.underlying.schedulePeriodically(action, initialDelay, period, unit);
    }

    public <T> Subscription schedulePeriodically(T state, Func2<? super Scheduler, ? super T, ? extends Subscription> action, long initialDelay, long period, TimeUnit unit) {
        return this.underlying.schedulePeriodically(state, action, initialDelay, period, unit);
    }

    public long now() {
        return this.underlying.now();
    }

    private Date findNextExecutionTime(Date guess, CronExpression cronExpression, Calendar calendar) {
        Date fireTime = cronExpression.getNextValidTimeAfter(guess);
        while (fireTime != null && calendar != null && !calendar.isTimeIncluded(fireTime.getTime())) {
            fireTime = this.findNextExecutionTime(fireTime, cronExpression, calendar);
        }
        return fireTime;
    }

    @Override
    public Subscription schedule(Action0 action, CronExpression cronExpression) {
        return this.schedule(action, cronExpression, null);
    }

    @Override
    public Subscription schedule(final Action0 action, CronExpression cronExpression, Calendar calendar) {
        return this.schedule(null, new Func2<Scheduler, Void, Subscription>(){

            public Subscription call(Scheduler scheduler, Void state) {
                action.call();
                return Subscriptions.empty();
            }
        }, cronExpression, calendar);
    }

    @Override
    public <T> Subscription schedule(T state, Func2<? super Scheduler, ? super T, ? extends Subscription> action, CronExpression cronExpression) {
        return this.schedule(state, action, cronExpression, null);
    }

    @Override
    public <T> Subscription schedule(T state, Func2<? super Scheduler, ? super T, ? extends Subscription> action, CronExpression cronExpression, Calendar calendar) {
        final AtomicBoolean complete = new AtomicBoolean();
        Date initialfireTime = this.findNextExecutionTime(new Date(this.now()), cronExpression, calendar);
        RecursiveAction<? super T> recursiveAction = new RecursiveAction<T>(complete, action, cronExpression, calendar, initialfireTime);
        final Subscription sub = initialfireTime == null ? Subscriptions.empty() : this.schedule(state, recursiveAction, initialfireTime);
        return Subscriptions.create((Action0)new Action0(){

            public void call() {
                complete.set(true);
                sub.unsubscribe();
            }
        });
    }

    final class RecursiveAction<T>
    implements Func2<Scheduler, T, Subscription> {
        private final AtomicBoolean complete;
        private final Func2<? super Scheduler, ? super T, ? extends Subscription> action;
        private final CronExpression cronExpression;
        private final Calendar calendar;
        private final Date dueTime;

        RecursiveAction(AtomicBoolean complete, Func2<? super Scheduler, ? super T, ? extends Subscription> action, CronExpression cronExpression, Calendar calendar, Date dueTime) {
            this.complete = complete;
            this.action = action;
            this.cronExpression = cronExpression;
            this.calendar = calendar;
            this.dueTime = dueTime;
        }

        public Subscription call(Scheduler scheduler, T state0) {
            if (!this.complete.get()) {
                final Subscription sub1 = scheduler.now() < this.dueTime.getTime() ? Subscriptions.empty() : (Subscription)this.action.call((Object)scheduler, state0);
                Date fireTime = RxCronForwardingScheduler.this.findNextExecutionTime(new Date(scheduler.now()), this.cronExpression, this.calendar);
                final Subscription sub2 = fireTime == null ? Subscriptions.empty() : scheduler.schedule(state0, new RecursiveAction<T>(this.complete, this.action, this.cronExpression, this.calendar, fireTime), fireTime);
                return Subscriptions.create((Action0)new Action0(){

                    public void call() {
                        sub1.unsubscribe();
                        sub2.unsubscribe();
                    }
                });
            }
            return Subscriptions.empty();
        }
    }
}

