(ns com.vadelabs.adapter-xtdb.pathom
  (:require
   [com.vadelabs.adapter-xtdb.main :as xtdb]
   [com.vadelabs.utils-core.interface :as uc]
   [com.wsscode.pathom3.connect.operation :as pco]))

(defn ^:private mutation
  [{:action/keys [identifier params output]} mutation-fn]
  (pco/mutation
    {::pco/op-name (uc/symbolize identifier)
     ::pco/mutate mutation-fn
     ::pco/params params
     ::pco/output output}))

(defn ^:private root-resolver
  [{:action/keys [identifier params output]} resolver-fn]
  (pco/resolver
    (cond-> {::pco/op-name (uc/symbolize identifier)
             ::pco/resolve resolver-fn
             ::pco/output [{identifier output}]}
      (seq params) (assoc ::pco/params params))))

(defn ^:private ident-resolver
  [{:action/keys [identifier input params output]} resolver-fn]
  (pco/resolver
    (cond-> {::pco/op-name (uc/symbolize identifier)
             ::pco/resolve resolver-fn}
      (seq input) (assoc ::pco/input input)
      (seq params) (assoc ::pco/params params)
      (seq output) (assoc ::pco/output output))))

(defmulti ^:private operation
  (fn [_aenv {:action/keys [type]}]
    type))

(defmethod operation :create
  [aenv action]
  (mutation action (partial xtdb/save! aenv action)))

(defmethod operation :update
  [aenv action]
  (mutation action (partial xtdb/save! aenv action)))

(defmethod operation :delete
  [aenv action]
  (mutation action (partial xtdb/delete! aenv action)))

(defmethod operation :upsert
  [aenv action]
  (mutation action (partial xtdb/save! aenv action)))

(defmethod operation :ident
  [aenv action]
  (ident-resolver action (partial xtdb/query aenv action)))

(defmethod operation :list
  [aenv action]
  (root-resolver action (partial xtdb/query aenv action)))

(defn operations
  [{:keys [actions] :as aenv}]
  (->> actions
    (mapv (partial operation aenv))))
