(ns com.vadelabs.sql-core.ast
  (:refer-clojure :exclude [compile])
  (:require
   [com.vadelabs.sql-core.spec :as spec]))

(defmulti compile
  (fn [{:keys [dialect]} [node-type _]]
    [dialect node-type]))

(defn fmt
  ([dsl]
   (fmt {:dialect :postgres} dsl))
  ([aenv dsl]
   (->> dsl
     spec/conform
     (compile aenv))))

#_(fmt [:create-table
        {:if-not-exists true}
        :pg.attribute
        [:group {:not-null true} :text]
        [:local_type {:not-null true} :text]
        [:local_key {:not-null true} :text]
        [:remote_key {:not-null true} :text]
        [:id {:not-null true, :default :gen-random-uuid} :uuid]
        [:remote_type {:not-null true} :text]
        [:target {:not-null true} :text]
        [:aliases {:not-null true} :text]
        [:cardinality {:not-null true} :enum]
        [:display_name {:not-null true} :text]
        [:doc {:not-null true} :text]
        [:primary-key {} :attribute_pkey :id]])

(comment

  (spec/conform
    [:create-type {:as :enum} :attribute_cardinality_enum [:one :many]])

  (def dsls
    [[:create-type {:as :enum} :attribute-cardinality :one :many]
     [:create-type {:as :enum} :identity-provider :google :github]
     [:create-schema {:if-not-exists true} :pgdemo]
     [:create-table {:if-not-exists true}
      :pgdemo.category
      [:id {:not-null true, :default :gen-random-uuid} :uuid]
      [:name {:not-null true} :text]
      [:description {:not-null true} :text]
      [:slug {:not-null true} :text]
      [:preview {:not-null true} :text]
      [:created-at
       {:not-null true, :default :now}
       :timestamp-without-time-zone]
      [:updated-at
       {:not-null true, :default :now}
       :timestamp-without-time-zone]
      [:primary-key {} :category--pkey :id]]
     [:create-table
      {:if-not-exists true}
      :pgdemo.adapter
      [:id {:not-null true, :default :gen-random-uuid} :uuid]
      [:nspace {:not-null true} :text]
      [:type {:not-null true} :text]
      [:name {:not-null true} :text]
      [:config {:not-null true} :jsonb]
      [:created-at
       {:not-null true, :default :now}
       :timestamp-without-time-zone]
      [:updated-at
       {:not-null true, :default :now}
       :timestamp-without-time-zone]
      [:primary-key {} :adapter--pkey :id]]
     [:create-table
      {:if-not-exists true}
      :pgdemo.attribute
      [:group {:not-null true} :text]
      [:local-type {:not-null true} :text]
      [:remote-key {:not-null true} :text]
      [:local-key {:not-null true} :text]
      [:remote-type {:not-null true} :text]
      [:id {:not-null true, :default :gen-random-uuid} :uuid]
      [:display-name {:not-null true} :text]
      [:target {:not-null true} :text]
      [:aliases {:not-null true} :text]
      [:cardinality {:not-null true} :enum]
      [:doc {:not-null true} :text]
      [:primary-key {} :attribute--pkey :id]]
     [:create-table
      {:if-not-exists true}
      :pgdemo.workspace
      [:description {:not-null true} :text]
      [:updated-at
       {:not-null true, :default :now}
       :timestamp-without-time-zone]
      [:projects {:not-null true} :uuid]
      [:slug {:not-null true} :text]
      [:logo {:not-null true} :text]
      [:name {:not-null true} :text]
      [:settings {:not-null true} :uuid]
      [:id {:not-null true, :default :gen-random-uuid} :uuid]
      [:profiles {:not-null true} :uuid]
      [:created-at
       {:not-null true, :default :now}
       :timestamp-without-time-zone]
      [:primary-key {} :workspace--pkey :id]]
     [:create-table
      {:if-not-exists true}
      :pgdemo.request
      [:id {:not-null true, :default :gen-random-uuid} :uuid]
      [:name {:not-null true} :text]
      [:description {:not-null true} :text]
      [:action {:not-null true} :text]
      [:created-at
       {:not-null true, :default :now}
       :timestamp-without-time-zone]
      [:updated-at
       {:not-null true, :default :now}
       :timestamp-without-time-zone]
      [:queries {:not-null true} :uuid]
      [:primary-key {} :request--pkey :id]]
     [:create-table
      {:if-not-exists true}
      :pgdemo.identity
      [:id {:not-null true, :default :gen-random-uuid} :uuid]
      [:provider {:not-null true} :enum]
      [:response {:not-null true} :jsonb]
      [:created-at
       {:not-null true, :default :now}
       :timestamp-without-time-zone]
      [:updated-at
       {:not-null true, :default :now}
       :timestamp-without-time-zone]
      [:primary-key {} :identity--pkey :id]]
     [:create-table
      {:if-not-exists true}
      :pgdemo.datasource
      [:description {:not-null true} :text]
      [:updated-at
       {:not-null true, :default :now}
       :timestamp-without-time-zone]
      [:adapter {:not-null true} :uuid]
      [:slug {:not-null true} :text]
      [:name {:not-null true} :text]
      [:icon {:not-null true} :text]
      [:collections {:not-null true} :uuid]
      [:preview {:not-null true} :text]
      [:categories {:not-null true} :uuid]
      [:id {:not-null true, :default :gen-random-uuid} :uuid]
      [:apis {:not-null true} :uuid]
      [:attributes {:not-null true} :uuid]
      [:created-at
       {:not-null true, :default :now}
       :timestamp-without-time-zone]
      [:primary-key {} :datasource--pkey :id]]
     [:create-table
      {:if-not-exists true}
      :pgdemo.api
      [:id {:not-null true, :default :gen-random-uuid} :uuid]
      [:name {:not-null true} :text]
      [:description {:not-null true} :text]
      [:created-at
       {:not-null true, :default :now}
       :timestamp-without-time-zone]
      [:updated-at
       {:not-null true, :default :now}
       :timestamp-without-time-zone]
      [:requests {:not-null true} :uuid]
      [:primary-key {} :api--pkey :id]]
     [:create-table
      {:if-not-exists true}
      :pgdemo.integration
      [:description {:not-null true} :text]
      [:updated-at
       {:not-null true, :default :now}
       :timestamp-without-time-zone]
      [:adapter {:not-null true} :uuid]
      [:slug {:not-null true} :text]
      [:datasource {:not-null true} :uuid]
      [:name {:not-null true} :text]
      [:icon {:not-null true} :text]
      [:collections {:not-null true} :uuid]
      [:preview {:not-null true} :text]
      [:categories {:not-null true} :uuid]
      [:id {:not-null true, :default :gen-random-uuid} :uuid]
      [:apis {:not-null true} :uuid]
      [:attributes {:not-null true} :uuid]
      [:created-at
       {:not-null true, :default :now}
       :timestamp-without-time-zone]
      [:primary-key {} :integration--pkey :id]]
     [:create-table
      {:if-not-exists true}
      :pgdemo.template
      [:description {:not-null true} :text]
      [:updated-at
       {:not-null true, :default :now}
       :timestamp-without-time-zone]
      [:slug {:not-null true} :text]
      [:name {:not-null true} :text]
      [:collections {:not-null true} :uuid]
      [:datasources {:not-null true} :uuid]
      [:preview {:not-null true} :text]
      [:categories {:not-null true} :uuid]
      [:id {:not-null true, :default :gen-random-uuid} :uuid]
      [:created-at
       {:not-null true, :default :now}
       :timestamp-without-time-zone]
      [:primary-key {} :template--pkey :id]]
     [:create-table
      {:if-not-exists true}
      :pgdemo.setting
      [:id {:not-null true, :default :gen-random-uuid} :uuid]
      [:option {:not-null true} :text]
      [:value {:not-null true} :text]
      [:type {:not-null true} :text]
      [:created-at
       {:not-null true, :default :now}
       :timestamp-without-time-zone]
      [:updated-at
       {:not-null true, :default :now}
       :timestamp-without-time-zone]
      [:primary-key {} :setting--pkey :id]]
     [:create-table
      {:if-not-exists true}
      :pgdemo.project
      [:description {:not-null true} :text]
      [:updated-at
       {:not-null true, :default :now}
       :timestamp-without-time-zone]
      [:slug {:not-null true} :text]
      [:workspace {:not-null true} :uuid]
      [:integrations {:not-null true} :uuid]
      [:name {:not-null true} :text]
      [:settings {:not-null true} :uuid]
      [:preview {:not-null true} :text]
      [:id {:not-null true, :default :gen-random-uuid} :uuid]
      [:created-at
       {:not-null true, :default :now}
       :timestamp-without-time-zone]
      [:primary-key {} :project--pkey :id]]
     [:create-table
      {:if-not-exists true}
      :pgdemo.device
      [:id {:not-null true, :default :gen-random-uuid} :uuid]
      [:identifier {:not-null true} :text]
      [:client {:not-null true} :text]
      [:user-agent {:not-null true} :text]
      [:token {:not-null true} :text]
      [:created-at
       {:not-null true, :default :now}
       :timestamp-without-time-zone]
      [:updated-at
       {:not-null true, :default :now}
       :timestamp-without-time-zone]
      [:primary-key {} :device--pkey :id]]
     [:create-table
      {:if-not-exists true}
      :pgdemo.query
      [:id {:not-null true, :default :gen-random-uuid} :uuid]
      [:type {:not-null true} :text]
      [:value {:not-null true} :text]
      [:comment {:not-null true} :text]
      [:created-at
       {:not-null true, :default :now}
       :timestamp-without-time-zone]
      [:updated-at
       {:not-null true, :default :now}
       :timestamp-without-time-zone]
      [:primary-key {} :query--pkey :id]]
     [:create-table
      {:if-not-exists true}
      :pgdemo.collection
      [:id {:not-null true, :default :gen-random-uuid} :uuid]
      [:name {:not-null true} :text]
      [:description {:not-null true} :text]
      [:slug {:not-null true} :text]
      [:preview {:not-null true} :text]
      [:created-at
       {:not-null true, :default :now}
       :timestamp-without-time-zone]
      [:updated-at
       {:not-null true, :default :now}
       :timestamp-without-time-zone]
      [:primary-key {} :collection--pkey :id]]
     [:create-table
      {:if-not-exists true}
      :pgdemo.profile
      [:updated-at
       {:not-null true, :default :now}
       :timestamp-without-time-zone]
      [:email {:not-null true} :text]
      [:phone {:not-null true} :text]
      [:name {:not-null true} :text]
      [:username {:not-null true} :text]
      [:settings {:not-null true} :uuid]
      [:id {:not-null true, :default :gen-random-uuid} :uuid]
      [:avatar {:not-null true} :text]
      [:devices {:not-null true} :uuid]
      [:workspaces {:not-null true} :uuid]
      [:created-at
       {:not-null true, :default :now}
       :timestamp-without-time-zone]
      [:identities {:not-null true} :uuid]
      [:primary-key {} :profile--pkey :id]]])

  (formatv dsls)
  :rcf)
