(ns com.vadelabs.sql-core.nodes.alter-schema
  (:require
   [com.vadelabs.sql-core.ast :as ast]
   [com.vadelabs.utils-core.interface :as uc]))

(defmethod ast/compile [:postgres :alter-schema]
  [env [_ {:keys [op props source target]}]]
  (let [{:keys [type] :or {type :rename-to}} props]
    (uc/sql-join " "
      (cond-> [(uc/sql-literal op)]
        source (into [(uc/sql-name env source)])
        type (into [(uc/sql-literal type)])
        target (into [(uc/sql-name env target)])))))

(comment

  (ast/format [:alter-schema {:if-not-exists true}
               :sone
               :stwo])

  :rcf)
