(ns com.vadelabs.sql-core.nodes.create-schema
  (:require
   [com.vadelabs.sql-core.ast :as ast]
   [com.vadelabs.utils-core.interface :as uc]))

(defmethod ast/compile [:postgres :create-schema]
  [env [_ {:keys [op props schema]}]]
  (let [{:keys [if-not-exists]} props]
    (uc/sql-join " "
      (cond-> [(uc/sql-literal op)]
        if-not-exists (into [(uc/sql-literal :if-not-exists)])
        schema (into [(uc/sql-name env schema)])))))

(comment

  (ast/format [:create-schema {:if-not-exists true}
               :sone])

  :rcf)
