(ns com.vadelabs.sql-core.nodes.primary-key
  (:require
   [com.vadelabs.sql-core.ast :as ast]
   [com.vadelabs.utils-core.interface :as uc]))

(defn ^:private format-children
  [env children]
  (->> children
    (map (partial ast/compile env))
    (uc/sql-join ", ")
    first
    (uc/str-format "(%s)")))

(defmethod ast/compile [:postgres :primary-key]
  [env [_ {:keys [op constraint children]}]]
  (uc/sql-join " "
    (cond-> [(uc/sql-literal :constraint)]
      constraint (into [(uc/sql-name env constraint)])
      op (into [(uc/sql-literal op)])
      (seq children) (into [(format-children env children)]))))

(comment

  (ast/format [:primary-key {} :pk-name
               :hello :world])

  :rcf)
