(ns com.vadelabs.sql-core.nodes.create-type
  (:require
   [com.vadelabs.sql-core.ast :as ast]
   [com.vadelabs.utils-core.interface :as uc]))

(defn ^:private format-children
  [env children]
  (->> children
    (map (partial ast/compile (assoc env :quote-style :single-quote)))
    (uc/sql-join ", ")
    first
    (uc/str-format "(%s)")))

(defmethod ast/compile [:postgres :create-type]
  [env [_ {:keys [op props type-name children]}]]
  (let [{:keys [as]} props]
    (uc/sql-join " "
      (cond-> [(uc/sql-literal op)]
        type-name (into [(uc/sql-name env type-name) "AS"])
        as (into [(uc/sql-literal as)])
        (seq children) (into [(format-children env children)])))))

(comment

  (ast/format [:create-type {:as :enum}
               :type-name
               :hello
               :world
               :type])

  (ast/format [:create-type {}
               :type-name
               [:col-one :uuid]
               [:col-two :text]])

  :rcf)
