(ns com.vadelabs.sql-core.nodes.drop-schema
  (:require
   [com.vadelabs.sql-core.ast :as ast]
   [com.vadelabs.utils-core.interface :as uc]))

(defmethod ast/compile [:postgres :drop-schema]
  [env [_ {:keys [op props schema]}]]
  (let [{:keys [if-exists cascade restrict]} props]
    (uc/sql-join " "
      (cond-> [(uc/sql-literal op)]
        if-exists (into [(uc/sql-literal :if-exists)])
        schema (into [(uc/sql-name env schema)])
        cascade (into [(uc/sql-literal :cascade)])
        restrict (into [(uc/sql-literal :restrict)])))))

(comment
  (ast/format [:drop-schema {:if-exists true}
               :sone])

  :rcf)
