(ns com.vadelabs.rest-core.interface
  (:require
   [com.vadelabs.rest-core.context :as context]
   [com.vadelabs.rest-core.interceptors :as interceptors]
   [com.vadelabs.rest-core.main :as rc]
   [com.vadelabs.rest-core.openapi :as openapi]
   [com.vadelabs.rest-core.postman :as postman]))

(defn bootstrap
  [& args]
  (apply rc/bootstrap args))

(defn handler-for
  [& args]
  (apply rc/handler-for args))

(defn url-for
  [& args]
  (apply rc/url-for args))

(defn request-for
  [& args]
  (apply rc/request-for args))

(defn response-for
  [& args]
  (apply rc/response-for args))

(defn explore
  [& args]
  (apply rc/explore args))

(defn update-handler
  [& args]
  (apply rc/update-handler args))

(defn postman->handlers
  [& args]
  (apply postman/handlers args))

(defn openapi->handlers
  [& args]
  (apply openapi/handlers args))

(defn openapi-base-url
  [& args]
  (apply openapi/base-url args))

(defn context-execute
  [& args]
  (apply context/execute args))

(def context-error
  ::context/error)

(defn remove-stack
  [& args]
  (apply context/remove-stack args))

(defn enqueue-route-interceptors
  [& args]
  (apply context/enqueue-route-interceptors args))

(defn inject
  [& args]
  (apply interceptors/inject args))
