(ns com.vadelabs.sql-core.nodes.insert
  (:require
   [com.vadelabs.sql-core.ast :as ast]
   [com.vadelabs.sql-core.spec :as spec]
   [next.jdbc.sql.builder :as sql]))

(defmethod ast/compile [:postgres :insert]
  [env [_ {:keys [props table children]}]]
  (let [key-map (into {} children)
        opts (merge spec/default-opts props)
        opts (cond-> opts
               (:on-conflict-do-nothing opts)
               (assoc :suffix "ON CONFLICT DO NOTHING"))]
    (sql/for-insert table key-map opts)))

(comment

  (ast/format
    [:insert {} :table-name
     [:hello :world]
     [:boom :shankar]])

  :rcf)

;; (defn insert
;;   ([table key-map]
;;    (insert table key-map nil))
;;   ([table key-map opts]
;;    (let [opts (merge default-opts opts)
;;          opts (cond-> opts
;;                 (:on-conflict-do-nothing opts)
;;                 (assoc :suffix "ON CONFLICT DO NOTHING"))]
;;      (sql/for-insert table key-map opts))))
