(ns com.vadelabs.adapter-xtdb.utils
  (:require [com.vadelabs.utils-core.interface :as uc]))

(defn primary-keys
  [attrs]
  (->> attrs
    (filter :attribute/primary-key)
    (mapv :attribute/qualified-key)))

(defn output
  ([attrs]
   (reduce
     (fn [acc {:attribute/keys [qualified-key qualified-target]}]
       (cond-> acc
         qualified-target (conj {qualified-key [qualified-target]})
         (not qualified-target) (conj qualified-key)))
     []
     attrs)))

(defn ^:private unique-keys
  [attrs]
  (->> attrs
    (filter :attribute/unique)
    (mapv :attribute/qualified-key)))

(defn ^:private action
  ([nspace entity attributes]
   (let [prefix-fn (partial uc/keywordize nspace entity)
         output (output attributes)]
     (into [{:action/identifier (prefix-fn :by-primary-key)
             :action/type :ident
             :action/scope :entity
             :action/input (primary-keys attributes)
             :action/output output}
            {:action/identifier (prefix-fn :list)
             :action/type :list
             :action/scope :entity
             :action/params []
             :action/output output}]
       (mapv (fn [k]
               {:action/identifier (uc/keywordize entity k :by-unique-key)
                :action/type :ident
                :action/scope :entity
                :action/priority 10
                :action/input [k]
                :action/output output})
         (unique-keys attributes)))))
  ([nspace attributes]
   (let [prefix-fn (partial uc/keywordize nspace)]
     [{:action/identifier (prefix-fn :delete!)
       :action/type :delete
       :action/scope :adapter
       :action/params []
       :action/output (primary-keys attributes)}
      {:action/identifier (prefix-fn :save!)
       :action/type :save
       :action/scope :adapter
       :action/params []
       :action/output (primary-keys attributes)}])))

(defn adapter-actions
  [attrs]
  (->> attrs
    (uc/group-by :attribute/remote-ns)
    (reduce-kv (fn [acc nspace attributes]
                 (into acc (action nspace attributes)))
      [])))

(defn entity-actions
  [{:adapter/keys [qualify-attributes]} attrs]
  (->> attrs
    (uc/group-by (juxt :attribute/remote-ns :attribute/remote-entity))
    (reduce-kv (fn [acc [nspace entity] attributes]
                 (into acc (if qualify-attributes
                             (action nspace entity attributes)
                             (action nil entity attributes))))
      [])))
