(ns com.vadelabs.rest-core.spec
  (:require
   [clojure.spec.alpha :as s]
   [schema.core :as sc]
   [malli.core :as m]))

(s/def ::api-root string?)

(s/def ::method keyword?)
(s/def ::route-name keyword?)
(s/def ::path-parts (s/coll-of (s/or :literal string? :arg keyword?)))

(s/def ::input-schema (s/nilable (s/and map? #(satisfies? sc/Schema %))))

(s/def ::path-schema ::input-schema)
(s/def ::query-schema ::input-schema)
(s/def ::body-schema ::input-schema)
(s/def ::form-schema ::input-schema)
(s/def ::headers-schema ::input-schema)

(s/def ::content-types (s/nilable (s/coll-of string?)))
(s/def ::produces ::content-types)
(s/def ::consumes ::content-types)

(s/def ::handler
  (s/keys
    :req-un [::route-name
             ::path-parts
             ::method]

    :opt-un [::path-schema
             ::query-schema
             ::body-schema
             ::form-schema
             ::headers-schema
             ::response-schemas
             ::produces
             ::consumes
             ::summary

            ;; only for swagger, information only
             ::swagger-definition
             ::path]))

(def handler
  (m/schema
    [:map {}
     [:route-name {} :keyword]
     [:path-template {} :string]
     [:method {} :keyword]
     [:parameters {} :any]
     [:responses {} :any]
     [:produces {:optional true} [:? [:vector :string]]]
     [:consumes {:optional true} [:? [:vector :string]]]
     [:summary {:optional true} :string]]))

#_(m/parse handler {:route-name :create-session
                    :path-template "passwordless/sessions"
                    :method :post
                    :summary "Create a Passwordless Session for a Magic Link Connection"
                    :parameters {:body [:map {:closed true}
                                        [:email :string]
                                        [:type {:default "MagicLink"} :string]
                                        [:redirectURI {:optional true} :string]
                                        [:state {:optional true} :string]
                                        [:connection {:optional true} :string]
                                        [:expiresIn {:optional true} :int]]}
                    :responses {200 {:body [:map {}
                                            [:object {} [:enum "passwordless_session"]]
                                            [:link {} :string]
                                            [:expires_at {} :any]
                                            [:email {} :string]
                                            [:id {} :string]]}}})

(s/def ::interceptor (s/keys :opt-un [::name ::enter ::leave ::catch]))
(s/def ::interceptors (s/nilable (s/coll-of ::interceptor)))
(s/def ::use-defaults? boolean?)

(s/def ::opts (s/nilable (s/keys :opt-un [::interceptors ::use-defaults?])))
