(ns com.vadelabs.sql-core.nodes.create-table
  (:require
   [com.vadelabs.sql-core.ast :as ast]
   [com.vadelabs.utils-core.interface :as uc]))

(defn ^:private format-columns
  [env cols]
  (->> cols
    (map (partial ast/compile env))
    (uc/sql-join ", ")
    first
    (uc/str-format "(%s)")))

(defmethod ast/compile [:postgres :create-table]
  [env [_ {:keys [op props table columns]}]]
  (let [{:keys [if-not-exists]} props]
    (uc/sql-join " "
      (cond-> [(uc/sql-literal op)]
        if-not-exists (into [(uc/sql-literal :if-not-exists)])
        table (into [(uc/sql-name env table)])
        (seq columns) (into [(format-columns env columns)])))))

(comment
  (ast/format
    [:create-table {:if-not-exists true}
     :sone
     [:cone {:not-null true} :uuid]])

  :rcf)
