(ns com.vadelabs.adapter-postgres.pathom
  (:require
   [com.vadelabs.adapter-core.interface :as ac]
   [com.vadelabs.sql-core.interface :as sc]
   [com.wsscode.pathom3.connect.planner :as pcp]
   :reload
   [edn-query-language.core :as eql]))

(defmethod ac/pathom-op [:postgres :save]
  [aenv action]
  (ac/mutation action (fn [_ pparams]
                        (tap> {:pparams pparams})
                        (sc/save! aenv pparams))))

(defmethod ac/pathom-op [:postgres :delete]
  [aenv action]
  (ac/mutation action (partial sc/delete! aenv action)))

#_(partial sc/query aenv action)

(defmethod ac/pathom-op [:postgres :fetch]
  [aenv {:action/keys [identifier] :as action}]
  (ac/fetch action (fn [penv pparams]

                     {identifier []})))

#_(first (into [] {:pg.profile/id #uuid "bead2ebf-3299-53aa-a07d-87bc386608ab"}))

(defmethod ac/pathom-op [:postgres :fetch-one]
  [aenv {:action/keys [input] :as action}]
  (ac/fetch-one action (fn [penv _]
                         (let [eql-query (-> penv ::pcp/graph ::pcp/source-ast eql/ast->query)
                               result (sc/query aenv eql-query)]
                           (tap> {:result result})
                           (-> result (get-in input) first)))))
