(ns com.vadelabs.adapter-postgres.utils
  (:require
   [com.vadelabs.adapter-core.interface :as ac]
   [com.vadelabs.utils-core.interface :as uc]))

(defn ->action
  ([nspace]
   (let [prefix-fn (partial uc/keywordize nspace)]
     [{:action/identifier (prefix-fn :delete!)
       :action/display-name "Delete records"
       :action/type :delete
       :action/params [:delta :data]
       :action/output [:tempids]}
      {:action/identifier (prefix-fn :save!)
       :action/display-name "Save records"
       :action/type :save
       :action/params [:delta :data]
       :action/output [:tempids]}]))
  ([nspace entity attributes]
   (let [prefix-fn (partial uc/keywordize nspace entity)]
     [{:action/identifier (prefix-fn :fetch)
       :action/display-name "Fetch records"
       :action/type :fetch
       :action/input []
       :action/output (ac/attributes->pathom-query attributes)}
      {:action/identifier (prefix-fn :fetch-one)
       :action/display-name "Fetch single record"
       :action/type :fetch-one
       :action/input [(prefix-fn :id)]
       :action/output (ac/attributes->pathom-query attributes)}])))

(defn adapter-actions
  [attrs]
  (->> attrs
    (uc/group-by :attribute/remote-ns)
    keys
    (reduce (fn [acc remote-ns]
              (into acc (->action remote-ns)))
      [])))

(defn entity-actions
  [attrs]
  (->> attrs
    (uc/group-by (juxt :attribute/remote-ns :attribute/remote-entity))
    (reduce-kv (fn [acc [remote-ns remote-entity] attributes]
                 (into acc (->action remote-ns remote-entity attributes)))
      [])))
