(ns com.vadelabs.rest-core.encoders
  (:require
   [com.vadelabs.utils-core.interface :as uc]
   #?(:clj [clojure.edn :as edn]
      :cljs [cljs.reader :as edn])))

(defn default-encoders
  ([]
   (merge
     #?(:clj
        {"application/transit+msgpack" {:encode #(uc/transit-encode % {:type :msgpack})
                                        :decode #(uc/transit-decode % {:type :msgpack})
                                        :as :byte-array}
         "application/transit+json"    {:encode #(uc/transit-encode % {:type :json})
                                        :decode #(uc/transit-decode % {:type :json})}})
     #?(:cljs
        {"application/transit+json"    {:encode #(uc/transit-encode % {:type :json})
                                        :decode #(uc/transit-decode % {:type :json})}})
     (uc/ordered-map

       "application/edn"             {:encode pr-str
                                      :decode edn/read-string}
       "application/json"            {:encode uc/json-encode
                                      :decode uc/json-decode}))))
