(ns com.vadelabs.turbo-core.dev
  (:require
   [com.vadelabs.turbo-core.linter :as linter]
   [com.vadelabs.turbo-core.utils :as utils]
   [com.vadelabs.utils-core.interface :as uc]))

(def ^:private goog-debug (with-meta 'goog.DEBUG {:tag 'boolean}))

(defn with-fast-refresh [var-sym fdecl]
  (let [signature `(when ~goog-debug
                     (when-let [f# (.-fast-refresh-signature ~var-sym)]
                       (f#)))
        maybe-conds (first fdecl)]
    (if (and (map? maybe-conds) (or (:pre maybe-conds) (:post maybe-conds)))
      (cons maybe-conds (cons signature (rest fdecl)))
      (cons signature fdecl))))

(defn fast-refresh-signature [var-sym body]
  `(when ~goog-debug
     (when (cljs.core/exists? js/window.turbo.dev)
       (let [sig# (js/window.turbo.dev.signature!)]
         (sig# ~var-sym ~(uc/str-join (utils/find-form linter/hook-call? body)) nil nil)
         (js/window.turbo.dev.register! ~var-sym (.-displayName ~var-sym))
         (set! (.-fast-refresh-signature ~var-sym) sig#)))))
