(ns com.vadelabs.turbo-css.tailwind.flex
  (:require
   [com.vadelabs.turbo-css.rule :refer [rule]]
   [com.vadelabs.turbo-css.utils :as utils]
   [com.vadelabs.utils-core.interface :as uc]))

(def ^:private basis
  {:basis-0 {:flex-basis "0px"}
   :basis-1 {:flex-basis "0.25rem"}
   :basis-2 {:flex-basis "0.5rem"}
   :basis-3 {:flex-basis "0.75rem"}
   :basis-4 {:flex-basis "1rem"}
   :basis-5 {:flex-basis "1.25rem"}
   :basis-6 {:flex-basis "1.5rem"}
   :basis-7 {:flex-basis "1.75rem"}
   :basis-8 {:flex-basis "2rem"}
   :basis-9 {:flex-basis "2.25rem"}
   :basis-10 {:flex-basis "2.5rem"}
   :basis-11 {:flex-basis "2.75rem"}
   :basis-12 {:flex-basis "3rem"}
   :basis-14 {:flex-basis "3.5rem"}
   :basis-16 {:flex-basis "4rem"}
   :basis-20 {:flex-basis "5rem"}
   :basis-24 {:flex-basis "6rem"}
   :basis-28 {:flex-basis "7rem"}
   :basis-32 {:flex-basis "8rem"}
   :basis-36 {:flex-basis "9rem"}
   :basis-40 {:flex-basis "10rem"}
   :basis-44 {:flex-basis "11rem"}
   :basis-48 {:flex-basis "12rem"}
   :basis-52 {:flex-basis "13rem"}
   :basis-56 {:flex-basis "14rem"}
   :basis-60 {:flex-basis "15rem"}
   :basis-64 {:flex-basis "16rem"}
   :basis-72 {:flex-basis "18rem"}
   :basis-80 {:flex-basis "20rem"}
   :basis-96 {:flex-basis "24rem"}
   :basis-auto {:flex-basis "auto"}
   :basis-px {:flex-basis "1px"}
   :basis-0.5 {:flex-basis "0.125rem"}
   :basis-1.5 {:flex-basis "0.375rem"}
   :basis-2.5 {:flex-basis "0.625rem"}
   :basis-3.5 {:flex-basis "0.875rem"}
   :basis-half {:flex-basis "50%"}
   :basis-one-third {:flex-basis "33.333333%"}
   :basis-two-third {:flex-basis "66.666667%"}
   :basis-one-fourth {:flex-basis "25%"}
   :basis-two-fourth {:flex-basis "50%"}
   :basis-three-fourth {:flex-basis "75%"}
   :basis-one-fifth {:flex-basis "20%"}
   :basis-two-fifth {:flex-basis "40%"}
   :basis-three-fifth {:flex-basis "60%"}
   :basis-four-fifth {:flex-basis "80%"}
   :basis-one-sixth {:flex-basis "16.666667%"}
   :basis-two-sixth {:flex-basis "33.333333%"}
   :basis-three-sixth {:flex-basis "50%"}
   :basis-four-sixth {:flex-basis "66.666667%"}
   :basis-five-sixth {:flex-basis "83.333333%"}
   :basis-one-twelth {:flex-basis "8.333333%"}
   :basis-two-twelth {:flex-basis "16.666667%"}
   :basis-three-twelth {:flex-basis "25%"}
   :basis-four-twelth {:flex-basis "33.333333%"}
   :basis-five-twelth {:flex-basis "41.666667%"}
   :basis-six-twelth {:flex-basis "50%"}
   :basis-seven-twelth {:flex-basis "58.333333%"}
   :basis-eight-twelth {:flex-basis "66.666667%"}
   :basis-nine-twelth {:flex-basis "75%"}
   :basis-ten-twelth {:flex-basis "83.333333%"}
   :basis-eleven-twelth {:flex-basis "91.666667%"}
   :basis-full {:flex-basis "100%"}})

(def ^:private direction
  {:flex-row {:flex-direction "row"}
   :flex-row-reverse {:flex-direction "row-reverse"}
   :flex-col {:flex-direction "column"}
   :flex-col-reverse {:flex-direction "column-reverse"}})

(def ^:private wrap
  {:flex-wrap {:flex-wrap "wrap"}
   :flex-wrap-reverse {:flex-wrap "wrap-reverse"}
   :flex-nowrap {:flex-wrap "nowrap"}})

(def ^:private flex
  {:flex-1 {:flex "1 1 0%"}
   :flex-auto {:flex "1 1 auto"}
   :flex-initial {:flex "0 1 auto"}
   :flex-none {:flex "none"}})

(def ^:private grow
  {:grow {:flex-grow 1}
   :grow-0 {:flex-grow 0}})

(def ^:private shrink
  {:shrink {:flex-shrink 1}
   :shrink-0 {:flex-shrink 0}})

(def ^:private order
  {:order-1 {:order 1}
   :order-2 {:order 2}
   :order-3 {:order 3}
   :order-4 {:order 4}
   :order-5 {:order 5}
   :order-6 {:order 6}
   :order-7 {:order 7}
   :order-8 {:order 8}
   :order-9 {:order 9}
   :order-10 {:order 10}
   :order-11 {:order 11}
   :order-12 {:order 12}
   :order-first {:order -9999}
   :order-last {:order 9999}
   :order-none {:order 0}})

(defmethod rule :gap
  ([_ x] [[:& {:gap (utils/as-unit x)}]]))

(defmethod rule :basis
  ([_ x] [[:& {:flex-basis (utils/as-unit x)}]]))

(def ^:private gap
  {:gap-0 {:gap "0px"}
   :gap-x-0 {:column-gap "0px"}
   :gap-y-0 {:row-gap "0px"}
   :gap-px {:gap "1px"}
   :gap-x-px {:column-gap "1px"}
   :gap-y-px {:row-gap "1px"}
   :gap-0.5 {:gap "0.125rem"}
   :gap-x-0.5 {:column-gap "0.125rem"}
   :gap-y-0.5 {:row-gap "0.125rem"}
   :gap-1 {:gap "0.25rem"}
   :gap-x-1 {:column-gap "0.25rem"}
   :gap-y-1 {:row-gap "0.25rem"}
   :gap-1.5 {:gap "0.375rem"}
   :gap-x-1.5 {:column-gap "0.375rem"}
   :gap-y-1.5 {:row-gap "0.375rem"}
   :gap-2 {:gap "0.5rem"}
   :gap-x-2 {:column-gap "0.5rem"}
   :gap-y-2 {:row-gap "0.5rem"}
   :gap-2.5 {:gap "0.625rem"}
   :gap-x-2.5 {:column-gap "0.625rem"}
   :gap-y-2.5 {:row-gap "0.625rem"}
   :gap-3 {:gap "0.75rem"}
   :gap-x-3 {:column-gap "0.75rem"}
   :gap-y-3 {:row-gap "0.75rem"}
   :gap-3.5 {:gap "0.875rem"}
   :gap-x-3.5 {:column-gap "0.875rem"}
   :gap-y-3.5 {:row-gap "0.875rem"}
   :gap-4 {:gap "1rem"}
   :gap-x-4 {:column-gap "1rem"}
   :gap-y-4 {:row-gap "1rem"}
   :gap-5 {:gap "1.25rem"}
   :gap-x-5 {:column-gap "1.25rem"}
   :gap-y-5 {:row-gap "1.25rem"}
   :gap-6 {:gap "1.5rem"}
   :gap-x-6 {:column-gap "1.5rem"}
   :gap-y-6 {:row-gap "1.5rem"}
   :gap-7 {:gap "1.75rem"}
   :gap-x-7 {:column-gap "1.75rem"}
   :gap-y-7 {:row-gap "1.75rem"}
   :gap-8 {:gap "2rem"}
   :gap-x-8 {:column-gap "2rem"}
   :gap-y-8 {:row-gap "2rem"}
   :gap-9 {:gap "2.25rem"}
   :gap-x-9 {:column-gap "2.25rem"}
   :gap-y-9 {:row-gap "2.25rem"}
   :gap-10 {:gap "2.5rem"}
   :gap-x-10 {:column-gap "2.5rem"}
   :gap-y-10 {:row-gap "2.5rem"}
   :gap-11 {:gap "2.75rem"}
   :gap-x-11 {:column-gap "2.75rem"}
   :gap-y-11 {:row-gap "2.75rem"}
   :gap-12 {:gap "3rem"}
   :gap-x-12 {:column-gap "3rem"}
   :gap-y-12 {:row-gap "3rem"}
   :gap-14 {:gap "3.5rem"}
   :gap-x-14 {:column-gap "3.5rem"}
   :gap-y-14 {:row-gap "3.5rem"}
   :gap-16 {:gap "4rem"}
   :gap-x-16 {:column-gap "4rem"}
   :gap-y-16 {:row-gap "4rem"}
   :gap-20 {:gap "5rem"}
   :gap-x-20 {:column-gap "5rem"}
   :gap-y-20 {:row-gap "5rem"}
   :gap-24 {:gap "6rem"}
   :gap-x-24 {:column-gap "6rem"}
   :gap-y-24 {:row-gap "6rem"}
   :gap-28 {:gap "7rem"}
   :gap-x-28 {:column-gap "7rem"}
   :gap-y-28 {:row-gap "7rem"}
   :gap-32 {:gap "8rem"}
   :gap-x-32 {:column-gap "8rem"}
   :gap-y-32 {:row-gap "8rem"}
   :gap-36 {:gap "9rem"}
   :gap-x-36 {:column-gap "9rem"}
   :gap-y-36 {:row-gap "9rem"}
   :gap-40 {:gap "10rem"}
   :gap-x-40 {:column-gap "10rem"}
   :gap-y-40 {:row-gap "10rem"}
   :gap-44 {:gap "11rem"}
   :gap-x-44 {:column-gap "11rem"}
   :gap-y-44 {:row-gap "11rem"}
   :gap-48 {:gap "12rem"}
   :gap-x-48 {:column-gap "12rem"}
   :gap-y-48 {:row-gap "12rem"}
   :gap-52 {:gap "13rem"}
   :gap-x-52 {:column-gap "13rem"}
   :gap-y-52 {:row-gap "13rem"}
   :gap-56 {:gap "14rem"}
   :gap-x-56 {:column-gap "14rem"}
   :gap-y-56 {:row-gap "14rem"}
   :gap-60 {:gap "15rem"}
   :gap-x-60 {:column-gap "15rem"}
   :gap-y-60 {:row-gap "15rem"}
   :gap-64 {:gap "16rem"}
   :gap-x-64 {:column-gap "16rem"}
   :gap-y-64 {:row-gap "16rem"}
   :gap-72 {:gap "18rem"}
   :gap-x-72 {:column-gap "18rem"}
   :gap-y-72 {:row-gap "18rem"}
   :gap-80 {:gap "20rem"}
   :gap-x-80 {:column-gap "20rem"}
   :gap-y-80 {:row-gap "20rem"}
   :gap-96 {:gap "24rem"}
   :gap-x-96 {:column-gap "24rem"}
   :gap-y-96 {:row-gap "24rem"}})

(def ^:private justify-content
  {:justify-start {:justify-content "flex-start"}
   :justify-end {:justify-content "flex-end"}
   :justify-center {:justify-content "center"}
   :justify-between {:justify-content "space-between"}
   :justify-around {:justify-content "space-around"}
   :justify-evenly {:justify-content "space-evenly"}})

(def ^:private justify-items
  {:justify-items-start {:justify-items "start"}
   :justify-items-end {:justify-items "end"}
   :justify-items-center {:justify-items "center"}
   :justify-items-stretch {:justify-items "stretch"}})

(def ^:private justify-self
  {:justify-self-auto {:justify-self "auto"}
   :justify-self-start {:justify-self "start"}
   :justify-self-end {:justify-self "end"}
   :justify-self-center {:justify-self "center"}
   :justify-self-stretch {:justify-self "stretch"}})

(def ^:private align-content
  {:content-center {:align-content "center"}
   :content-start {:align-content "flex-start"}
   :content-end {:align-content "flex-end"}
   :content-between {:align-content "space-between"}
   :content-around {:align-content "space-around"}
   :content-evenly {:align-content "space-evenly"}})

(def ^:private align-items
  {:items-start {:align-items "flex-start"}
   :items-end {:align-items "flex-end"}
   :items-center {:align-items "center"}
   :items-baseline {:align-items "baseline"}
   :items-stretch {:align-items "stretch"}})

(def ^:private align-self
  {:self-auto {:align-self "auto"}
   :self-start {:align-self "flex-start"}
   :self-end {:align-self "flex-end"}
   :self-center {:align-self "center"}
   :self-stretch {:align-self "stretch"}
   :self-baseline {:align-self "baseline"}})

(def dynamic-rules
  {})

(def static-rules
  (uc/deep-merge
    basis
    direction
    wrap
    flex
    grow
    shrink
    order
    gap
    justify-content
    justify-items
    justify-self
    align-content
    align-items
    align-self))
