(ns com.vadelabs.turbo-css.tailwind.animation
  (:require
   [garden.stylesheet :refer [at-keyframes]]))

(def keyframes
  "List of all supported keyframes"
  [(at-keyframes :spin
     [:from {:transform "rotate(0deg)"}]
     [:to {:transform "rotate(360deg)"}])
   (at-keyframes :ping
     ["75%, 100%" {:transform "scale(2)"
                   :opacity 0}])
   (at-keyframes :pulse
     ["0%, 100%" {:opacity 1}]
     ["50%" {:opacity 0.5}])
   (at-keyframes :bounce
     ["0%, 100%" {:transform "translateY(-25%)"
                  :animation-timing-function "cubic-bezier(0.8, 0, 1, 1)"}]
     ["50%" {:transform "translateY(0)"
             :animation-timing-function "cubic-bezier(0, 0, 0.2, 1)"}])])

(def dynamic-rules
  {})

(def static-rules
  {:animate-none {:animation "none"}
   :animate-spin {:animation "spin 1s linear infinite"}
   :animate-ping {:animation "ping 1s cubic-bezier(0, 0, 0.2, 1) infinite"}
   :animate-pulse {:animation "pulse 2s cubic-bezier(0.4, 0, 0.6, 1) infinite"}
   :animate-bounce {:animation "bounce 1s infinite"}})
