(ns com.vadelabs.utils-core.uuid
  (:refer-clojure :exclude [next uuid zero?])
  (:require
   #?@(:clj [[clj-uuid :as impl]
             [clojure.core :as c]]
       :cljs [[com.vadelabs.utils-core.uuid-impl :as impl]
              [cljs.reader :as reader]
              [cljs.core :as c]]))
  #?(:clj (:import
           java.util.UUID
           java.io.Writer)))

(def zero
  #uuid "00000000-0000-0000-0000-000000000000")

(defn zero?
  [v]
  (= zero v))

(defn next
  []
  #?(:clj (impl/v1)
     :cljs (impl/v1)))

(def uuid-rx
  #"^[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}$")

(defn random
  "Alias for clj-uuid/v4."
  []
  #?(:clj (impl/v4)
     :cljs (impl/v4)))
#_(c/uuid? "00000000-0000-0000-0000-000000000000")
#_(re-matches uuid-rx "00000-0000-0000-0000-000000000000")
(defn uuid
  "Parse string uuid representation into proper UUID instance."
  ([]
   (random))
  ([s]
   #?(:clj (if (and (string? s) (re-matches uuid-rx s))
             (UUID/fromString s)
             (impl/v5 impl/+namespace-url+ s))
      :cljs (c/uuid s))))

(defn custom
  ([a] #?(:clj (UUID. 0 a) :cljs (c/uuid (impl/custom 0 a))))
  ([b a] #?(:clj (UUID. b a) :cljs (c/uuid (impl/custom b a)))))

(def ^:private tag "vade/tempid")

#?(:cljs
   (deftype TempId [^:mutable id ^:mutable __hash]
     Object
     (toString [this]
       (pr-str this))
     IEquiv
     (-equiv [this other]
       (and (instance? TempId other)
         (= (. this -id) (. other -id))))
     IHash
     (-hash [_this]
       (when (nil? __hash)
         (set! __hash (hash id)))
       __hash)
     IPrintWithWriter
     (-pr-writer [_ writer _]
       (write-all writer "#" tag "[\"" id "\"]"))))

#?(:cljs
   (defn tempid
     "Create a new tempid."
     ([]
      (tempid (random-uuid)))
     ([id]
      (TempId. id nil))))

#?(:clj
   (defrecord TempId [id]
     Object
     (toString [this]
       (pr-str this))))

#?(:clj
   (defmethod print-method TempId [^TempId x ^Writer writer]
     (.write writer (str "#" tag "[\"" (.id x) "\"]"))))

#?(:clj
   (defn tempid
     "Create a new tempid."
     ([]
      (tempid (java.util.UUID/randomUUID)))
     ([uuid]
      (TempId. uuid))))

(defn tempid?
  "Returns true if the given `x` is a tempid."
  #?(:cljs {:tag boolean})
  [x]
  (instance? TempId x))

#?(:cljs (reader/register-tag-parser! 'vade/tempid c/identity))
