(ns com.vadelabs.turbo-css.tailwind.effect
  (:require
   [com.vadelabs.turbo-css.rule :refer [rule]]
   [com.vadelabs.turbo-css.tailwind.tokens :as tokens]
   [com.vadelabs.turbo-css.utils :as utils]
   [com.vadelabs.utils-core.interface :as uc]
   [garden.compiler :refer [render-css]]))

(defmethod rule :box-shadow
  ([_ x] [[:& {:box-shadow x}]]))

(def ^:private box-shadow
  {:shadow-sm {:box-shadow "0 1px 2px 0 rgb(0 0 0 / 0.05)"}
   :shadow	{:box-shadow "0 1px 3px 0 rgb(0 0 0 / 0.1), 0 1px 2px -1px rgb(0 0 0 / 0.1)"}
   :shadow-md	{:box-shadow "0 4px 6px -1px rgb(0 0 0 / 0.1), 0 2px 4px -2px rgb(0 0 0 / 0.1)"}
   :shadow-lg	{:box-shadow "0 10px 15px -3px rgb(0 0 0 / 0.1), 0 4px 6px -4px rgb(0 0 0 / 0.1)"}
   :shadow-xl	{:box-shadow "0 20px 25px -5px rgb(0 0 0 / 0.1), 0 8px 10px -6px rgb(0 0 0 / 0.1)"}
   :shadow-2xl	{:box-shadow "0 25px 50px -12px rgb(0 0 0 / 0.25)"}
   :shadow-inner	{:box-shadow "inset 0 2px 4px 0 rgb(0 0 0 / 0.05)"}
   :shadow-none	{:box-shadow "0 0 #0000"}})

(def ^:private box-shadow-color
  (reduce-kv
    (fn [acc k v]
      (assoc acc
        (uc/keywordize (uc/str "shadow-" (uc/namify k)))
        {:--tw-shadow-color v}))
    {}
    tokens/color-tokens))

(def ^:private opacity
  {:opacity-0 {:opacity 0}
   :opacity-5 {:opacity 0.05}
   :opacity-10 {:opacity 0.1}
   :opacity-20 {:opacity 0.2}
   :opacity-25 {:opacity 0.25}
   :opacity-30 {:opacity 0.3}
   :opacity-40 {:opacity 0.4}
   :opacity-50 {:opacity 0.5}
   :opacity-60 {:opacity 0.6}
   :opacity-70 {:opacity 0.7}
   :opacity-75 {:opacity 0.75}
   :opacity-80 {:opacity 0.8}
   :opacity-90 {:opacity 0.9}
   :opacity-95 {:opacity 0.95}
   :opacity-100 {:opacity 1}})

(def ^:private mix-blend-mode
  {:mix-blend-normal {:mix-blend-mode "normal"}
   :mix-blend-multiply {:mix-blend-mode "multiply"}
   :mix-blend-screen {:mix-blend-mode "screen"}
   :mix-blend-overlay {:mix-blend-mode "overlay"}
   :mix-blend-darken {:mix-blend-mode "darken"}
   :mix-blend-lighten {:mix-blend-mode "lighten"}
   :mix-blend-color-dodge {:mix-blend-mode "color-dodge"}
   :mix-blend-color-burn {:mix-blend-mode "color-burn"}
   :mix-blend-hard-light {:mix-blend-mode "hard-light"}
   :mix-blend-soft-light {:mix-blend-mode "soft-light"}
   :mix-blend-difference {:mix-blend-mode "difference"}
   :mix-blend-exclusion {:mix-blend-mode "exclusion"}
   :mix-blend-hue {:mix-blend-mode "hue"}
   :mix-blend-saturation {:mix-blend-mode "saturation"}
   :mix-blend-color {:mix-blend-mode "color"}
   :mix-blend-luminosity {:mix-blend-mode "luminosity"}
   :mix-blend-plus-lighter {:mix-blend-mode "plus-lighter"}})

(def ^:private background-blend-mode
  {:bg-blend-normal	{:background-blend-mode "normal"}
   :bg-blend-multiply	{:background-blend-mode "multiply"}
   :bg-blend-screen	{:background-blend-mode "screen"}
   :bg-blend-overlay	{:background-blend-mode "overlay"}
   :bg-blend-darken	{:background-blend-mode "darken"}
   :bg-blend-lighten	{:background-blend-mode "lighten"}
   :bg-blend-color-dodge	{:background-blend-mode "color-dodge"}
   :bg-blend-color-burn	{:background-blend-mode "color-burn"}
   :bg-blend-hard-light	{:background-blend-mode "hard-light"}
   :bg-blend-soft-light	{:background-blend-mode "soft-light"}
   :bg-blend-difference	{:background-blend-mode "difference"}
   :bg-blend-exclusion	{:background-blend-mode "exclusion"}
   :bg-blend-hue	{:background-blend-mode "hue"}
   :bg-blend-saturation	{:background-blend-mode "saturation"}
   :bg-blend-color	{:background-blend-mode "color"}
   :bg-blend-luminosity	{:background-blend-mode "luminosity"}})

(def dynamic-rules
  {})

(def static-rules
  (uc/deep-merge
    background-blend-mode
    box-shadow
    box-shadow-color
    mix-blend-mode
    opacity))
