(ns com.vadelabs.turbo-ui.checkbox.interface
  (:require
   [com.vadelabs.turbo-core.interface :as tc :refer [defui $]]
   [com.vadelabs.turbo-ui.checkbox.styles :as s]))

(defui component
  [props]
  (let [class (s/classes props)
        removable-keys  (-> s/variants :variants keys)
        rprops (apply dissoc props removable-keys)
        fprops (cond-> rprops
                 true (assoc :type "checkbox")
                 class (assoc :class class))]
    ($ :input fprops)))
