(ns com.vadelabs.turbo-ui.grid.styles
  (:require
   [com.vadelabs.turbo-css.interface :refer [sx]]
   [com.vadelabs.utils-core.interface :as uc]))

(def variants
  {:base (sx :grid :border-box)
   :defaults {}
   :variants {:align
              {:start (sx :items-start)
               :center (sx :items-center)
               :end (sx :items-end)
               :stretch (sx :items-stretch)
               :baseline (sx :items-baseline)}
              :justify
              {:start (sx :justify-start)
               :center (sx :justify-center)
               :end (sx :justify-end)
               :between (sx :justify-between)}
              :flow
              {:row (sx :grid-flow-row)
               :column (sx :grid-flow-column)
               :dense (sx :grid-flow-dense)
               :row-dense (sx :grid-flow-row-dense)
               :column-dense (sx :grid-flow-column-dense)}
              :columns
              {1 (sx :grid-cols-1)
               2 (sx :grid-cols-2)
               3 (sx :grid-cols-3)
               4 (sx :grid-cols-4)}
              :gap
              {1 (sx :gap-1)
               2 (sx :gap-2)
               3 (sx :gap-3)
               4 (sx :gap-4)
               5 (sx :gap-5)
               6 (sx :gap-6)
               7 (sx :gap-7)
               8 (sx :gap-8)
               9 (sx :gap-9)}
              :gap-x
              {1 (sx [:gap-x 1])
               2 (sx [:gap-x 2])
               3 (sx [:gap-x 3])
               4 (sx [:gap-x 4])
               5 (sx [:gap-x 5])
               6 (sx [:gap-x 6])
               7 (sx [:gap-x 7])
               8 (sx [:gap-x 8])
               9 (sx [:gap-x 9])}
              :gap-y
              {1 (sx [:gap-y 1])
               2 (sx [:gap-y 2])
               3 (sx [:gap-y 3])
               4 (sx [:gap-y 4])
               5 (sx [:gap-y 5])
               6 (sx [:gap-y 6])
               7 (sx [:gap-y 7])
               8 (sx [:gap-y 8])
               9 (sx [:gap-y 9])}}})

(def classes
  (uc/cva variants))
