(ns com.vadelabs.turbo-ui.tabs.interface
  (:refer-clojure :exclude [list])
  (:require
   ["@radix-ui/react-tabs" :refer [Root List Trigger Content]]
   [com.vadelabs.turbo-core.interface :as tc :refer [defui $]]
   [com.vadelabs.turbo-css.interface :refer [sx]]
   #_[com.vadelabs.turbo-ui.switch.styles :as s]
   #_[com.vadelabs.turbo-icons.interface :as ti]))

(defui container "Root"
  [props]
  ($ Root props))

(defui list "TabsList"
  [{:keys [ref class] :as props}]
  ($ List (merge props {:ref ref
                        :class (str class " "
                                 (sx :inline-flex :items-center :justify-center :p-1
                                   #_:rounded-md
                                   #_:bg-slate-100
                                   #_[:dark :bg-slate-800]))})))

(defui trigger "TabsTrigger "
  [{:keys [ref class] :as props}]
  ($ Trigger (merge
               {:ref ref
                :class (str class " "
                         (sx :inline-flex :items-center :justify-center
                           [:min-w "100px"]
                        ;;  [:rounded "0.185rem"]
                           :px-6 :py-2
                           :border-b-2 :border-transparent
                           :text-xl :font-medium :text-slate-700
                           :transition-all
                           [:disabled :pointer-events-none :opacity-50]
                           ["[data-state=\"active\"]"
                            :border-gray-900]
                           #_[:dark
                              :text-slate-200
                              ["[data-state=\"active\"]"
                               :bg-slate-900
                               :text-slate-100]]))}
               props)))

(defui content "TabsContent"
  [{:keys [ref class] :as props}]
  ($ Content (merge props {:ref ref
                           :class (str class " "
                                    (sx :mt-2 :p-2
                                      #_[:dark :border-slate-700]))})))
