(ns com.vadelabs.turbo-ui.footer.styles
  (:require
   [com.vadelabs.turbo-css.interface :refer [sx]]
   [com.vadelabs.utils-core.interface :as uc]))

(def variants
  {:base (sx :text-gray-400
           :mt-16
           :flex
           :gap-2)
   :defaults {:align :center
              :text :md}
   :variants {:align {:left (sx :justify-start)
                      :center (sx :justify-center)
                      :right (sx :justify-end)}
              :text {:sm (sx :text-xs)
                     :md (sx :text-sm)
                     :lg (sx :text-md)}}})

(defn classes
  ([props]
   ((uc/cva variants) props))
  ([class props]
   ((uc/cva {:base class}) props)))
