(ns com.vadelabs.turbo-css.tailwind.layout
  (:refer-clojure :exclude [floats])
  (:require
   [garden.stylesheet :refer [at-media]]
   [com.vadelabs.turbo-css.rule :refer [rule]]
   [com.vadelabs.utils-core.interface :as uc]))

(def ^:private aspect-ratio
  {:aspect-auto {:aspect-ratio "auto"}
   :aspect-square {:aspect-ratio "1 / 1"}
   :aspect-video {:aspect-ratio "16 / 9"}})

(defmethod rule :container
  ([_] [[:& {:width "100%"}
         #_(at-media {:min-width "768px"}
             {:max-width "768px"})]]))

;; [:at-media {:min-width "640px"}
;;           {:max-width "640px"}]
;;          [:at-media {:min-width "768px"}
;;           {:max-width "768px"}]
;;          [:at-media {:min-width "1024px"}
;;           {:max-width "1024px"}]
;;          [:at-media {:min-width "1280px"}
;;           {:max-width "1280px"}]
;;          [:at-media {:min-width "1536px"}
;;           {:max-width "1536px"}]

(def ^:private columns
  {:columns-1	{:columns 1}
   :columns-2	{:columns 2}
   :columns-3	{:columns 3}
   :columns-4	{:columns 4}
   :columns-5	{:columns 5}
   :columns-6	{:columns 6}
   :columns-7	{:columns 7}
   :columns-8	{:columns 8}
   :columns-9	{:columns 9}
   :columns-10	{:columns 10}
   :columns-11	{:columns 11}
   :columns-12	{:columns 12}
   :columns-auto	{:columns "auto"}
   :columns-3xs	{:columns "16rem"}
   :columns-2xs	{:columns "18rem"}
   :columns-xs	{:columns "20rem"}
   :columns-sm	{:columns "24rem"}
   :columns-md	{:columns "28rem"}
   :columns-lg	{:columns "32rem"}
   :columns-xl	{:columns "36rem"}
   :columns-2xl	{:columns "42rem"}
   :columns-3xl	{:columns "48rem"}
   :columns-4xl	{:columns "56rem"}
   :columns-5xl	{:columns "64rem"}
   :columns-6xl	{:columns "72rem"}
   :columns-7xl	{:columns "80rem"}})

(def ^:private break-after
  {:break-after-auto	{:break-after "auto"}
   :break-after-avoid	{:break-after "avoid"}
   :break-after-all	{:break-after "all"}
   :break-after-avoid-page	{:break-after "avoid-page"}
   :break-after-page	{:break-after "page"}
   :break-after-left	{:break-after "left"}
   :break-after-right	{:break-after "right"}
   :break-after-column	{:break-after "column"}})

(def ^:private break-before
  {:break-before-auto	{:break-before "auto"}
   :break-before-avoid	{:break-before "avoid"}
   :break-before-all	{:break-before "all"}
   :break-before-avoid-page	{:break-before "avoid-page"}
   :break-before-page	{:break-before "page"}
   :break-before-left	{:break-before "left"}
   :break-before-right	{:break-before "right"}
   :break-before-column	{:break-before "column"}})

(def ^:private break-inside
  {:break-inside-auto	{:break-inside "auto"}
   :break-inside-avoid	{:break-inside "avoid"}
   :break-inside-avoid-page	{:break-inside "avoid-page"}
   :break-inside-avoid-column	{:break-inside "avoid-column"}})

(def ^:private box-decoration
  {:box-decoration-clone {:box-decoration-break "clone"}
   :box-decoration-slice {:box-decoration-break "slice"}})

(def ^:private box-sizing
  {:box-border {:box-sizing "border-box"}
   :box-content {:box-sizing "content-box"}})

(def ^:private display
  {:block	{:display "block"}
   :inline-block	{:display "inline-block"}
   :inline	{:display "inline"}
   :flex	{:display "flex"}
   :inline-flex	{:display "inline-flex"}
   :table	{:display "table"}
   :inline-table	{:display "inline-table"}
   :table-caption	{:display "table-caption"}
   :table-cell	{:display "table-cell"}
   :table-column	{:display "table-column"}
   :table-column-group	{:display "table-column-group"}
   :table-footer-group	{:display "table-footer-group"}
   :table-header-group	{:display "table-header-group"}
   :table-row-group	{:display "table-row-group"}
   :table-row	{:display "table-row"}
   :flow-root	{:display "flow-root"}
   :grid	{:display "grid"}
   :inline-grid	{:display "inline-grid"}
   :contents	{:display "contents"}
   :list-item	{:display "list-item"}
   :hidden	{:display "none"}})

(def ^:private floats
  "https://tailwindcss.com/docs/float"
  {:float-right {:float "right"}
   :float-left {:float "left"}
   :float-none {:float "none"}})

(def ^:private clear
  "https://tailwindcss.com/docs/clear"
  {:clear-left {:clear "left"}
   :clear-right {:clear "right"}
   :clear-both {:clear "both"}
   :clear-none {:clear "none"}})

(def ^:private isolation
  {:isolate {:isolation "isolate"}
   :isolation-auto {:isolation "auto"}})

(def ^:private object-fit
  {:object-contain	{:object-fit "contain"}
   :object-cover	{:object-fit "cover"}
   :object-fill	{:object-fit "fill"}
   :object-none	{:object-fit "none"}
   :object-scale-down	{:object-fit "scale-down"}})

(def ^:private object-position
  {:object-bottom	{:object-position "bottom"}
   :object-center	{:object-position "center"}
   :object-left	{:object-position "left"}
   :object-left-bottom	{:object-position "left bottom"}
   :object-left-top	{:object-position "left top"}
   :object-right	{:object-position "right"}
   :object-right-bottom	{:object-position "right bottom"}
   :object-right-top	{:object-position "right top"}
   :object-top	{:object-position "top"}})

(def ^:private overflow
  {:overflow-auto	{:overflow "auto"}
   :overflow-hidden	{:overflow "hidden"}
   :overflow-clip	{:overflow "clip"}
   :overflow-visible	{:overflow "visible"}
   :overflow-scroll	{:overflow "scroll"}
   :overflow-x-auto	{:overflow-x "auto"}
   :overflow-y-auto	{:overflow-y "auto"}
   :overflow-x-hidden	{:overflow-x "hidden"}
   :overflow-y-hidden	{:overflow-y "hidden"}
   :overflow-x-clip	{:overflow-x "clip"}
   :overflow-y-clip	{:overflow-y "clip"}
   :overflow-x-visible	{:overflow-x "visible"}
   :overflow-y-visible	{:overflow-y "visible"}
   :overflow-x-scroll	{:overflow-x "scroll"}
   :overflow-y-scroll	{:overflow-y "scroll"}})

(def ^:private overscroll
  {:overscroll-auto	{:overscroll-behavior "auto"}
   :overscroll-contain	{:overscroll-behavior "contain"}
   :overscroll-none	{:overscroll-behavior "none"}
   :overscroll-y-auto	{:overscroll-behavior-y "auto"}
   :overscroll-y-contain	{:overscroll-behavior-y "contain"}
   :overscroll-y-none	{:overscroll-behavior-y "none"}
   :overscroll-x-auto	{:overscroll-behavior-x "auto"}
   :overscroll-x-contain	{:overscroll-behavior-x "contain"}
   :overscroll-x-none	{:overscroll-behavior-x "none"}})

(def ^:private position
  {:static {:position "static"}
   :fixed {:position "fixed"}
   :absolute {:position "absolute"}
   :relative {:position "relative"}
   :sticky {:position "sticky"}})

(defmethod rule :content
  ([_ x] [[:& {:content x}]]))

(def ^:private position-tokens
  {"0" "0px"
   "px" "1px"
   "0.5"  "0.125rem"
   "1" "0.25rem"
   "1.5" "0.375rem"
   "2" "0.5rem"
   "2.5" "0.625rem"
   "3" "0.75rem"
   "3.5" "0.875rem"
   "4" "1rem"
   "5" "1.25rem"
   "6" "1.5rem"
   "7" "1.75rem"
   "8" "2rem"
   "9" "2.25rem"
   "10" "2.5rem"
   "11" "2.75rem"
   "12" "3rem"
   "14" "3.5rem"
   "16" "4rem"
   "20" "5rem"
   "24" "6rem"
   "28" "7rem"
   "32" "8rem"
   "36" "9rem"
   "40" "10rem"
   "44" "11rem"
   "48" "12rem"
   "52" "13rem"
   "56" "14rem"
   "60" "15rem"
   "64" "16rem"
   "72" "18rem"
   "80" "20rem"
   "96" "24rem"
   "auto" "auto"
   "half" "50%"
   "one-third" "33.333333%"
   "two-third" "66.666666%"
   "one-fourth" "25%"
   "two-fourth" "50%"
   "three-fourth" "75%"
   "full" "100%"})

(def ^:private top-right-bottom-left
  (reduce-kv
    (fn [acc k v]
      (assoc acc
        (uc/keywordize (uc/str "inset-" k)) {:top v :right v :bottom v :left v}
        (uc/keywordize (uc/str "inset-x-" k)) {:right v :left v}
        (uc/keywordize (uc/str "inset-y-" k)) {:top v :bottom v}
        (uc/keywordize (uc/str "top-" k)) {:top v}
        (uc/keywordize (uc/str "right-" k)) {:right v}
        (uc/keywordize (uc/str "bottom-" k)) {:bottom v}
        (uc/keywordize (uc/str "left-" k)) {:left v}))
    {}
    position-tokens))

(def ^:private visibility
  {:visible {:visibility "visible"}
   :invisible {:visibility "hidden"}})

(def ^:private z-index
  {:z-0	{:z-index 0}
   :z-10	{:z-index 10}
   :z-20	{:z-index 20}
   :z-30	{:z-index 30}
   :z-40	{:z-index 40}
   :z-50	{:z-index 50}
   :z-auto	{:z-index "auto"}})

(def dynamic-rules
  {:aspect (fn [x] {:aspect-ratio x})
   :column (fn [x] {:column x})
   :isolation (fn [x] {:isolation x})
   :object-fit (fn [x] {:object-fit x})
   :object-position (fn [x] {:object-position x})
   :overflow (fn [x] {:overflow x})
   :overscroll-behavior (fn [x] {:overscroll-behavior x})

   :position (fn [x] {:position x})

   :inset (fn [x] {:top x :right x :bottom x :left x})
   :inset-x (fn [x] {:right x :left x})
   :inset-y (fn [x] {:top x :bottom x})
   :top (fn [x] {:top x})
   :right (fn [x] {:right x})
   :bottom (fn [x] {:bottom x})
   :left (fn [x] {:left x})

   :visibility (fn [x] {:visibility x})
   :z (fn [x] {:z-index x})
   :z-index (fn [x] {:z-index x})})

(def static-rules
  (uc/deep-merge
    aspect-ratio
    columns
    break-after
    break-before
    break-inside
    box-decoration
    box-sizing
    display
    floats
    clear
    isolation
    object-fit
    object-position
    overflow
    overscroll
    position
    top-right-bottom-left
    visibility
    z-index))
