(ns com.vadelabs.turbo-css.tailwind.ring
  (:require
  ;;  [com.vadelabs.turbo-css.rule :refer [rule]]
  ;;  [com.vadelabs.turbo-css.tailwind.spacing :as spacing]
   [com.vadelabs.turbo-css.tailwind.tokens :as tokens]
  ;;  [com.vadelabs.turbo-css.utils :as utils]
   [com.vadelabs.utils-core.interface :as uc]
  ;;  [garden.compiler :refer [render-css]]
   ))

;; RING WIDTH ;;
(def ^:private ring-width
  {:ring-0	{:--tw-ring-offset-shadow "var(--tw-ring-inset) 0 0 0 var(--tw-ring-offset-width) var(--tw-ring-offset-color)"
            :--tw-ring-shadow "var(--tw-ring-inset) 0 0 0 calc(0px + var(--tw-ring-offset-width)) var(--tw-ring-color)"
            :box-shadow "var(--tw-ring-offset-shadow),var(--tw-ring-shadow),var(--tw-shadow,0 0 #0000)"}
   :ring-1	{:--tw-ring-offset-shadow "var(--tw-ring-inset) 0 0 0 var(--tw-ring-offset-width) var(--tw-ring-offset-color)"
            :--tw-ring-shadow "var(--tw-ring-inset) 0 0 0 calc(1px + var(--tw-ring-offset-width)) var(--tw-ring-color)"
            :box-shadow "var(--tw-ring-offset-shadow),var(--tw-ring-shadow),var(--tw-shadow,0 0 #0000)"}
   :ring-2	{:--tw-ring-offset-shadow "var(--tw-ring-inset) 0 0 0 var(--tw-ring-offset-width) var(--tw-ring-offset-color)"
            :--tw-ring-shadow "var(--tw-ring-inset) 0 0 0 calc(2px + var(--tw-ring-offset-width)) var(--tw-ring-color)"
            :box-shadow "var(--tw-ring-offset-shadow),var(--tw-ring-shadow),var(--tw-shadow,0 0 #0000)"}
   :ring	{:--tw-ring-offset-shadow "var(--tw-ring-inset) 0 0 0 var(--tw-ring-offset-width) var(--tw-ring-offset-color)"
          :--tw-ring-shadow "var(--tw-ring-inset) 0 0 0 calc(3px + var(--tw-ring-offset-width)) var(--tw-ring-color)"
          :box-shadow "var(--tw-ring-offset-shadow),var(--tw-ring-shadow),var(--tw-shadow,0 0 #0000)"}
   :ring-4	{:--tw-ring-offset-shadow "var(--tw-ring-inset) 0 0 0 var(--tw-ring-offset-width) var(--tw-ring-offset-color)"
            :--tw-ring-shadow "var(--tw-ring-inset) 0 0 0 calc(4px + var(--tw-ring-offset-width)) var(--tw-ring-color)"
            :box-shadow "var(--tw-ring-offset-shadow),var(--tw-ring-shadow),var(--tw-shadow,0 0 #0000)"}
   :ring-8	{:--tw-ring-offset-shadow "var(--tw-ring-inset) 0 0 0 var(--tw-ring-offset-width) var(--tw-ring-offset-color)"
            :--tw-ring-shadow "var(--tw-ring-inset) 0 0 0 calc(8px + var(--tw-ring-offset-width)) var(--tw-ring-color)"
            :box-shadow "var(--tw-ring-offset-shadow),var(--tw-ring-shadow),var(--tw-shadow,0 0 #0000)"}
   :ring-inset	{:--tw-ring-inset "inset"}})

;; RING COLOUR ;;
(def ^:private ring-color
  (reduce-kv
    (fn [acc k v]
      (assoc acc
        (uc/keywordize (uc/str "ring-" (uc/namify k)))
        {:--tw-ring-color v}))
    {}
    tokens/color-tokens))

;; RING OFFSET WIDTH ;;
(def ^:private ring-offset-width
  {:ring-offset-0	{:--tw-ring-offset-width "0px"
                   }
   :ring-offset-1	{:--tw-ring-offset-width "1px"
                   }
   :ring-offset-2	{:--tw-ring-offset-width "2px"
                   }
   :ring-offset-4	{:--tw-ring-offset-width "4px"
                   }
   :ring-offset-8	{:--tw-ring-offset-width "8px"
                   }})

;; RING OFFSET COLOUR ;;
(def ^:private ring-offset-color
  (reduce-kv
    (fn [acc k v]
      (assoc acc
        (uc/keywordize (uc/str "ring-offset-" (uc/namify k)))
        {:--tw-ring-offset-color v
        }))
    {}
    tokens/color-tokens))

(def static-rules "STATIC RULES FOR RING"
  (uc/deep-merge
    ring-width
    ring-color
    ring-offset-width
    ring-offset-color))
