(ns com.vadelabs.turbo-ui.alert-dialog.interface
  (:require
   ["@radix-ui/react-alert-dialog" :refer [Root Trigger Portal
                                           Overlay Content Title
                                           Description Action
                                           Cancel]]
   [com.vadelabs.turbo-core.interface :as tc :refer [defui $]]
   [com.vadelabs.turbo-css.interface :refer [sx]]))

(defui component
  [props]
  ($ Root props))

(defui trigger
  [props]
  ($ Trigger props))

(defui portal
  [{:keys [children] :as props}]
  (let [fprops (apply dissoc props [:children])]
    ($ Portal fprops
      ($ :div {:class (sx :fixed :inset-0 :z-50
                        :flex :items-start :justify-center
                        [:sm :items-center])}
        children))))
(defui overlay
  [props]
  (let [class (sx :fixed :inset-0 :z-50
                :bg-black :opacity-50
                :backdrop-blur-sm :transition-all :duration-100
                :flex :items-center :justify-center
                ["[data-state=\"closed\"]" :animate-out :fade-out]
                ["[data-state=\"open\"]" :fade-in])
        fprops (cond-> props
                 class (assoc :class class))]
    ($ Overlay fprops)))

(defui content
  [props]
  (let [class (sx :fixed :z-50 :grid
                :w-full :max-w-lg :scale-100
                :gap-4 :bg-white :p-6 :opacity-100
                :animate-in :fade-in-90
                :slide-in-from-bottom-10
                [:sm :rounded-lg :zoom-in-90 :slide-in-from-bottom-0]
                [:md :w-full]
                [:dark :bg-slate-900])
        fprops (cond-> props
                 class (assoc :class class))]
    ($ portal {}
      ($ overlay {})
      ($ Content fprops))))

(defui header
  [props]
  (let [class (sx :flex :flex-col :space-y-2 :text-center [:sm :text-left])
        fprops (cond-> props
                 class (assoc :class class))]
    ($ :div fprops)))

(defui footer
  [props]
  (let [class (sx :flex :flex-col-reverse
                [:sm :flex-row :justify-end :space-x-2])
        fprops (cond-> props
                 class (assoc :class class))]
    ($ :div fprops)))

(defui title
  [props]
  (let [class (sx :text-lg :font-semibold :text-slate-900
                [:dark :text-slate-50])
        fprops (cond-> props
                 class (assoc :class class))]
    ($ Title fprops)))

(defui description
  [props]
  (let [class (sx :text-sm :text-slate-500
                [:dark :text-slate-400])
        fprops (cond-> props
                 class (assoc :class class))]
    ($ Description fprops)))

(defui action
  [props]
  (let [class (sx :inline-flex :h-10 :items-center :justify-center
                :rounded-md :bg-slate-900 :py-2 :px-4 :text-sm
                :font-semibold :text-white :transition-colors
                [:hover :bg-slate-700]
                [:focus :outline-none :ring-2 :ring-slate-400 :ring-offset-2]
                [:disabled :cursor-not-allowed :opacity-50]
                [:dark :bg-slate-100 :text-slate-900
                 [:hover :bg-slate-200]
                 [:focus :ring-slate-400
                  :ring-offset-slate-900]])
        fprops (cond-> props
                 class (assoc :class class))]
    ($ Action fprops)))

(defui cancel
  [props]
  (let [class (sx :mt-2 :inline-flex :h-10 :items-center
                :justify-center :rounded-md :border
                :border-slate-200 :bg-transparent :py-2 :px-4
                :text-sm :font-semibold :text-slate-900
                :transition-colors
                [:hover :bg-slate-100]
                [:focus :outline-none :ring-2 :ring-slate-400 :ring-offset-2]
                [:disabled :cursor-not-allowed :opacity-50]
                [:dark :border-slate-700 :text-slate-100
                 [:hover :bg-slate-700]
                 [:focus :ring-slate-400 :ring-offset-slate-900]]

                [:sm :mt-0])
        fprops (cond-> props
                 class (assoc :class class))]
    ($ Cancel fprops)))
