(ns com.vadelabs.turbo-ui.explorer.ui.viewer.csv
  (:require ["papaparse" :refer [parse]]
            [com.vadelabs.turbo-ui.explorer.ui.inspector :as ins]))

(defn parse-csv [csv-string]
  (try
    (with-meta
      (js->clj (.-data (parse csv-string)))
      {:com.vadelabs.turbo-ui.explorer.viewer/default :com.vadelabs.turbo-ui.explorer.viewer/table})
    (catch :default _e ::invalid)))

(defn csv? [value] (string? value))

(defn inspect-csv [csv-string]
  [ins/tabs
   {:com.vadelabs.turbo-ui.explorer.viewer/csv (parse-csv csv-string)
    "..."              csv-string}])

(def viewer
  {:predicate csv?
   :component inspect-csv
   :name :com.vadelabs.turbo-ui.explorer.viewer/csv
   :doc "Parse a string as a CSV and use the table viewer by default."})
