(ns com.vadelabs.turbo-ui.explorer.ui.viewer.edn
  (:require [com.vadelabs.turbo-ui.explorer.runtime.edn :as edn]
            [com.vadelabs.turbo-ui.explorer.ui.inspector :as ins]))

(defn read-string [edn-string]
  (try (edn/read-string edn-string)
    (catch :default e (ins/error->data e))))

(defn edn? [value] (string? value))

(defn inspect-edn [edn-string]
  [ins/tabs
   {:com.vadelabs.turbo-ui.explorer.viewer/edn (read-string edn-string)
    "..."              edn-string}])

(def viewer
  {:predicate edn?
   :component inspect-edn
   :name :com.vadelabs.turbo-ui.explorer.viewer/edn
   :doc "Parse a string as EDN. Will render error if parsing fails."})
