(ns com.vadelabs.turbo-ui.explorer.ui.viewer.jwt
  (:require [clojure.string :as str]
            [goog.crypt.base64 :as Base64]
            [com.vadelabs.turbo-ui.explorer.ui.inspector :as ins]))

(defn- parse-json [value]
  (js->clj (.parse js/JSON (js/atob value)) :keywordize-keys true))

(defn- parse-jwt [jwt]
  (try
    (let [[header payload signature] (str/split jwt ".")]
      (with-meta
        {:jwt/header (parse-json header)
         :jwt/payload
         (with-meta (parse-json payload)
           {:com.vadelabs.turbo-ui.explorer.viewer/for
            {:auth_time :com.vadelabs.turbo-ui.explorer.viewer/date-time
             :exp :com.vadelabs.turbo-ui.explorer.viewer/date-time
             :iat :com.vadelabs.turbo-ui.explorer.viewer/date-time}})
         :jwt/signature
         (Base64/decodeStringToUint8Array signature)}
        {:com.vadelabs.turbo-ui.explorer.viewer/for
         {:jwt/signature :com.vadelabs.turbo-ui.explorer.viewer/bin}}))
    (catch :default e (ins/error->data e))))

(defn inspect-jwt [jwt]
  [ins/tabs
   {:com.vadelabs.turbo-ui.explorer.viewer/jwt (parse-jwt jwt)
    "..."              jwt}])

(def viewer
  {:predicate string?
   :component inspect-jwt
   :name :com.vadelabs.turbo-ui.explorer.viewer/jwt
   :doc "Parse a string as a JWT. Will render error if parsing fails."})
