(ns com.vadelabs.turbo-ui.footer.interface
  (:require
   [com.vadelabs.turbo-core.interface :as tc :refer [defui $]]
   [com.vadelabs.turbo-ui.footer.styles :as s]
   [com.vadelabs.turbo-ui.separator.interface :as separator]))

(defui component
  [props]
  (let [class (s/classes props)
        rprops (apply dissoc props (-> s/variants :variants keys))
        fprops (cond-> rprops
                 class (assoc :class class))]
    ($ :div fprops
      ($ :p {} "©️ 2023 Vade Labs Pvt. Ltd.")
      ($ separator/component {:orientation :vertical})
      ($ :a {:href "/privacy-policy"} "Privacy & Terms"))))