(ns com.vadelabs.turbo-ui.heading.styles
  (:require
   [com.vadelabs.turbo-css.interface :refer [sx]]
   [com.vadelabs.utils-core.interface :as uc]))

(def variants
  {:base (sx :accent-brand-500 :h-4 :w-4 :shrink-0
           :rounded-sm :border :border-slate-300
           [:focus :outline-none
            :ring-2 :ring-slate-400
            :ring-offset-2]
           [:disabled :cursor-not-allowed
            :opacity-50]
           [:dark :border-slate-700
            :text-slate-50
            [:focus :ring-slate-400
             :ring-offset-slate-900]])
   :defaults {}
   :variants {:color
              {:primary (sx)
               :secondary (sx)
               :success (sx)
               :warning (sx)
               :error (sx)}
              :size
              {:xs (sx)
               :sm (sx)
               :md (sx)
               :lg (sx)
               :xl (sx)}}})

(defn classes
  ([props]
   ((uc/cva variants) props))
  ([class props]
   ((uc/cva {:base class}) props)))
