(ns com.vadelabs.turbo-ui.logo.interface
  (:require
   [com.vadelabs.turbo-core.interface :as tc :refer [defui $]]
   [com.vadelabs.turbo-css.interface :refer [sx]]
   [com.vadelabs.turbo-ui.logo.styles :as s]))

(defui component
  [props]
  (let [class (s/classes props)
        removable-keys  (into (-> s/variants :variants keys))
        rprops (apply dissoc props removable-keys)
        fprops (cond-> rprops
                 class (assoc :class class))]
    ($ :div {:class (sx :mx-auto :w-52 :max-w-52)}
      ($ :img fprops))))
