(ns com.vadelabs.turbo-ui.separator.styles
  (:require
   [com.vadelabs.turbo-css.interface :refer [sx]]
   [com.vadelabs.utils-core.interface :as uc]))

(def variants
  {:base (sx :border-none :outline-none)
   :defaults {:orientation :horizontal}
   :variants {:orientation
              {:horizontal (sx :relative
                             :text-gray-300
                             :h-5
                             :my-2
                             [:before
                              [:content "\"\""]
                              :bg-gray-300
                              :absolute
                              :left-0
                              :top-half
                              :w-full
                              [:h "0.8px"]]
                             [:after
                              [:content "attr(data-content)"]
                              :relative
                              :px-2
                              :bg-gray-100
                              :inline-block
                              :leading-2])
               :vertical (sx [:w "1px"]
                           :min-h-full
                           :self-stretch
                           :bg-gray-300)}}})

(defn classes
  [props]
  ((uc/cva variants) props))
