(ns com.vadelabs.turbo-ui.switch.styles
  (:require
   [com.vadelabs.turbo-css.interface :refer [sx]]
   [com.vadelabs.utils-core.interface :as uc]))

(def variants
  {:base (sx :max-w-xl
           :w-full
           :py-16
           :px-24
           :shadow-lg)
   :defaults {:bg :gray
              :align :center
              :rounded :md}
   :variants {:bg
              {:gray (sx :bg-gray-100)}

              :rounded
              {:sm (sx :rounded-lg)
               :md (sx :rounded-2xl)
               :lg (sx :rounded-3xl)}

              :align
              {:center (sx :mx-auto :text-center)}}})

(defn classes
  ([props]
   ((uc/cva variants) props))
  ([class props]
   ((uc/cva {:base class}) props)))
