(ns com.vadelabs.turbo-ui.text.interface
  (:require
   [com.vadelabs.turbo-core.interface :as tc :refer [defui $]]
   [com.vadelabs.turbo-ui.text.styles :as s]))

(defui component
  [{:keys [as]
    :as props
    :or {as :p}}]
  (let [class (s/classes (assoc props :as as))
        removable-keys  (-> s/variants :variants keys)
        rprops (apply dissoc props removable-keys)
        fprops (cond-> rprops
                 class (assoc :class class))]
    (case as
      :blockquote ($ :blockquote fprops)
      :body1 ($ :body1 fprops)
      :body2 ($ :body2 fprops)
      :body3 ($ :body3 fprops)
      :h1 ($ :h1 fprops)
      :h2 ($ :h2 fprops)
      :h3 ($ :h3 fprops)
      :h4 ($ :h4 fprops)
      :p ($ :p fprops))))
