(ns com.vadelabs.turbo-ui.text.styles
  (:require
   [com.vadelabs.turbo-css.interface :refer [sx]]
   [com.vadelabs.utils-core.interface :as uc]))

(def variants
  {:base (sx)
   :defaults {}
   :variants {:as
              {:blockquote (sx :mt-6 :border-l-2
                             :border-slate-300 :pl-6 :italic :text-slate-800
                             [:dark
                              :border-slate-600
                              :text-slate-200])
               :code (sx :relative :rounded :bg-slate-100
                       [:py "0.2rem"]
                       [:px "0.3rem"]
                       :font-mono
                       :text-sm :font-semibold
                       :text-slate-900)
               :h1 (sx :scroll-m-20
                     :text-2xl
                     :font-bold
                     #_:tracking-tight
                     #_[:lg :text-5xl])
               :h2 (sx :scroll-m-20
                     :pb-2 :text-xl
                     :font-semibold
                     #_:tracking-tight
                     #_[:first :mt-0]
                     #_[:dark :border-b-slate-700])
               :h3 (sx :scroll-m-20
                     :text-sm
                     :font-semibold
                     #_:tracking-tight)
               :h4 (sx :mt-8 :scroll-m-20 :text-xl :font-semibold #_:tracking-tight)

               :body1 (sx :text-sm)

               :body2 (sx :text-xs)

               :body3 (sx :text-xs :font-semibold)

               :lead (sx :text-xl :text-slate-700
                       [:dark :text-slate-400])
               :p (sx :leading-7
                    [:pseudo ":not(first-child)"
                     [:mt-6]])
               :small (sx :text-sm :font-medium :leading-none)
               :subtle (sx :text-sm :text-slate-500
                         [:dark :text-slate-400])}
              :color
              {:brand (sx :text-brand-500)
               :gray (sx :text-gray-500)
               :black (sx :text-gray-900)}
              :size
              {:xs (sx)
               :sm (sx :text-sm)
               :md (sx)
               :lg (sx)
               :xl (sx)}
              :align
              {:left (sx :text-left)
               :right (sx :text-right)
               :center (sx :text-center)}}})

(defn classes
  [props]
  ((uc/cva variants) props))
