"use strict";

goog.provide("com.vadelabs.turbo_utils.globals");


goog.scope(function() {
  com.vadelabs.turbo_utils.globals.global = goog.global;

  function createGlobalEventEmitter(k) {
    /* Allow mocked objects to be event emitters, so other modules
     * may subscribe to them.
     */
    return {
      addListener(...args) {
      },
      removeListener(...args) {
      },
      addEventListener(...args) {
      },
      removeEventListener(...args) {
      }
    }
  }

  com.vadelabs.turbo_utils.globals.window = (function() {
    if (typeof goog.global.window !== "undefined") {
      return goog.global.window;
    } else {
      return createGlobalEventEmitter();
    }
  })();

  com.vadelabs.turbo_utils.globals.document = (function() {
    if (typeof goog.global.document !== "undefined") {
      return goog.global.document;
    } else {
      return createGlobalEventEmitter();
    }
  })();

  com.vadelabs.turbo_utils.globals.location = (function() {
    if (typeof goog.global.location !== "undefined") {
      return goog.global.location;
    } else {
      return createGlobalEventEmitter();
    }
  })();

  com.vadelabs.turbo_utils.globals.navigator = (function() {
    if (typeof goog.global.navigator !== "undefined") {
      return goog.global.navigator;
    } else {
      return createGlobalEventEmitter();
    }
  })();

  com.vadelabs.turbo_utils.globals.FormData = (function() {
    if (typeof goog.global.FormData !== "undefined") {
      return goog.global.FormData;
    } else {
      return function() {};
    }
  })();
});
