(ns com.vadelabs.utils-core.json
  (:require
   #?(:clj [charred.api :as json]
      :cljs [cljs-bean.core :refer [->clj ->js]])))

(defn encode
  [body]
  #?(:clj (json/write-json-str body)
     :cljs (-> body ->js js/JSON.stringify)))

(defn decode
  ([body]
   (decode body keyword))
  ([body key-fn]
   #?(:clj (json/read-json body :key-fn key-fn)
      :cljs (-> body js/JSON.parse ->clj))))
