(ns com.vadelabs.utils-core.spec
  (:require
   [malli.core :as m]
   [malli.error :as me]
   [malli.dev.pretty :as pretty]
   [malli.transform :as mt]
   [com.vadelabs.utils-core.anomaly :as anomaly]))

(def email-rx
  #"[a-zA-Z0-9_.+-]+@[a-zA-Z0-9-]+\.[a-zA-Z0-9-.]+")

(def uuid-rx
  #"^[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}$")

(def max-safe-int
  (int 1e6))

(def min-safe-int
  (int -1e6))

(defn parse-email
  [s]
  (some->> s (re-seq email-rx) first))

(defn conform
  [spec data]
  (let [parse-fn (m/parser spec)
        result (parse-fn data)]
    (when (= result ::m/invalid)
      (let [hint (-> spec (m/explain data) me/humanize)]
        (tap> {:hint hint})
        (anomaly/fault (pr-str hint))))
    result))
