(ns com.vadelabs.utils-core.test
  (:require
   [clojure.test :refer [assert-expr do-report]]))

(defmethod assert-expr 'thrown-with-data? [msg form]
  (let [data (second form)
        body (nthnext form 2)]
    `(try ~@body
       (do-report {:type :fail :message ~msg
                   :expected '~form :actual nil})
       (catch clojure.lang.ExceptionInfo e#
         (let [expected# ~data
               actual# (ex-data e#)]
           (if (= expected# actual#)
             (do-report {:type :pass :message ~msg
                         :expected expected# :actual actual#})
             (do-report {:type :fail :message ~msg
                         :expected expected# :actual actual#})))
         e#))))

(defmethod assert-expr 'spec-valid? [msg form]
  ;; (is (spec-valid? schema value))
  (let [args (rest form)]
    `(let [result# (validate ~@args)]
       (if result#
         (do-report {:actual   '~form
                     :expected '~form
                     :message  ~msg
                     :type     :pass})
         ;; Be careful not to aggressively thread the expression below. We
         ;; need to pass the spliced `args` to
         ;; `clojure.spec.alpha/explain-data`.
         (do-report {:actual   (-> (explain ~@args)
                                 (me/humanize))
                     :expected '~form
                     :message  ~msg
                     :type     :fail})))))

(defmethod assert-expr 'spec-invalid? [msg form]
  ;; (is (invalid? ::sut/thing value))
  (let [args (rest form)]
    `(let [result# (not (validate ~@args))]
       (if result#
         (do-report {:actual   '~form
                     :expected '~form
                     :message  ~msg
                     :type     :pass})
         ;; We can't describe problems here because we can't negate specs, so
         ;; the best we can do is return the original form. It's probably better
         ;; to use generative testing via `defspec` et al.
         (do-report {:actual   '(valid? ~@args)
                     :expected '~form
                     :message  ~msg
                     :type     :fail})))))
