(ns com.vadelabs.utils-core.spec)

(def email-rx
  #"[a-zA-Z0-9_.+-]+@[a-zA-Z0-9-]+\.[a-zA-Z0-9-.]+")

(def uuid-rx
  #"^[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}$")

(def max-safe-int
  (int 1e6))

(def min-safe-int
  (int -1e6))

(defn parse-email
  [s]
  (some->> s (re-seq email-rx) first))

(defn conform
  [spec data])
