(ns com.vadelabs.utils-core.transformer
  (:require
   [clojure.edn :as edn]))

(defmulti coerce
  "Multimethod to coerce values based on the type parameter"
  (fn [type _value]
    (when type
      (-> type name keyword))))

(defmethod coerce :default
  [_ x]
  x)

(defmethod coerce :string
  [_ x]
  (str x))

(defmethod coerce :symbol
  [_ x]
  (symbol x))

(defmethod coerce :long
  [_ x]
  (if (nil? x)
    0
    (try
      #?(:clj  (Long/parseLong x)
         :cljs (js/parseInt x))
      (catch #?(:clj Exception :cljs :default) _e
        0))))

(defmethod coerce :double
  [_ value]
  (edn/read-string value))

(defmethod coerce :uri
  [_ value]
  (cond
    (keyword? value) (str (namespace value) "/" (name value))
    :else value))
