(ns com.vadelabs.utils-core.uri
  (:refer-clojure :exclude [uri?])
  (:require
   [com.vadelabs.utils-core.data :as ud]
   [lambdaisland.uri :as u]
   [lambdaisland.uri.normalize :as un])
  #?(:clj
     (:import lambdaisland.uri.URI)))

(defn uri
  [& args]
  (apply u/uri args))

(defn join
  [& args]
  (apply u/join args))

(defn query-encode
  [& args]
  (apply u/query-encode args))

(defn percent-encode
  [& args]
  (apply un/percent-encode args))

(defn uri?
  [& args]
  (apply u/uri? args))

(defn query-string->map
  [s]
  (u/query-string->map s))

(defn default-encode-value
  [v]
  (ud/namify v))

(defn get-domain
  [{:keys [host port]}]
  (cond-> host
    port (str ":" port)))

(defn map->query-string
  ([params] (map->query-string params nil))
  ([params {:keys [value-fn key-fn]
            :or {value-fn default-encode-value
                 key-fn identity}}]
   (->> params
     (into {} (comp
                (remove #(nil? (second %)))
                (map (fn [[k v]] [(key-fn k) (value-fn v)]))))
     (u/map->query-string))))

#?(:clj
   (defmethod print-method lambdaisland.uri.URI [^URI this ^java.io.Writer writer]
     (.write writer "#")
     (.write writer (str u/edn-tag))
     (.write writer " ")
     (.write writer (pr-str (.toString this))))

   :cljs
   (extend-type u/URI
     IPrintWithWriter
     (-pr-writer [this writer _opts]
       (write-all writer "#" (str u/edn-tag) " " (pr-str (.toString this))))))
