(ns com.vadelabs.utils.json
  (:require
    #?@(:clj [[charred.api :as json]
              [clojure.java.io :as io]]))
  #?(:cljs
     (:require-macros
       [com.vadelabs.utils.json])))


(defn encode
  [body]
  #?(:clj (json/write-json-str body)
     :cljs (-> body clj->js js/JSON.stringify)))


(defn decode
  ([body]
    (decode body keyword))
  ([body key-fn]
    #?(:clj (json/read-json body :key-fn key-fn)
       :cljs (-> body js/JSON.parse (js->clj :keywordize-keys (boolean key-fn))))))


#?(:clj
   (defmacro resource
     [resource-name]
     (-> resource-name
       io/resource
       slurp
       (json/read-json :key-fn keyword))))
