(ns com.vadelabs.utils.id
  (:refer-clojure :exclude [next uuid zero? uuid?])
  (:require
    #?@(:clj [[clj-uuid :as impl]
              [clojure.core :as c]])
    #?(:cljs [cljs.core :as c])
    #?(:cljs [com.vadelabs.utils.uuid_impl :as impl]))
  #?(:clj
     (:import
       java.util.UUID)))


(def zero
  #uuid "00000000-0000-0000-0000-000000000000")


(defn zero?
  [v]
  (= zero v))


(defn next
  []
  #?(:clj (impl/v1)
     :cljs (impl/v1)))


(def uuid-rx
  #"^[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}$")


(defn random
  "Alias for clj-uuid/v4."
  []
  #?(:clj (impl/v4)
     :cljs (impl/v4)))


(defn uuid?
  [s]
  (c/uuid? s))


(defn uuid
  "Parse string uuid representation into proper UUID instance."
  ([]
    (random))
  ([s]
    #?(:clj
       (cond
         (nil? s) (random)
         (c/uuid? s) s
         (and s (string? s) (re-matches uuid-rx s)) (UUID/fromString s)
         :else (impl/v5 impl/+namespace-url+ s))
       :cljs (c/uuid s))))


(defn custom
  ([a] #?(:clj (UUID. 0 a) :cljs (c/uuid (impl/custom 0 a))))
  ([b a] #?(:clj (UUID. b a) :cljs (c/uuid (impl/custom b a)))))
